/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysis;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsDestination;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsSource;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class DataframeAnalyticsSummary
implements JsonpSerializable {
    private final String id;
    private final DataframeAnalyticsSource source;
    private final DataframeAnalyticsDestination dest;
    private final DataframeAnalysis analysis;
    @Nullable
    private final String description;
    @Nullable
    private final String modelMemoryLimit;
    @Nullable
    private final Integer maxNumThreads;
    @Nullable
    private final JsonValue analyzedFields;
    @Nullable
    private final Boolean allowLazyStart;
    @Nullable
    private final Long createTime;
    @Nullable
    private final String version;
    public static final JsonpDeserializer<DataframeAnalyticsSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsSummary::setupDataframeAnalyticsSummaryDeserializer, Builder::build);

    public DataframeAnalyticsSummary(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.source = Objects.requireNonNull(builder.source, "source");
        this.dest = Objects.requireNonNull(builder.dest, "dest");
        this.analysis = Objects.requireNonNull(builder.analysis, "analysis");
        this.description = builder.description;
        this.modelMemoryLimit = builder.modelMemoryLimit;
        this.maxNumThreads = builder.maxNumThreads;
        this.analyzedFields = builder.analyzedFields;
        this.allowLazyStart = builder.allowLazyStart;
        this.createTime = builder.createTime;
        this.version = builder.version;
    }

    public DataframeAnalyticsSummary(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public DataframeAnalyticsSource source() {
        return this.source;
    }

    public DataframeAnalyticsDestination dest() {
        return this.dest;
    }

    public DataframeAnalysis analysis() {
        return this.analysis;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public String modelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    @Nullable
    public Integer maxNumThreads() {
        return this.maxNumThreads;
    }

    @Nullable
    public JsonValue analyzedFields() {
        return this.analyzedFields;
    }

    @Nullable
    public Boolean allowLazyStart() {
        return this.allowLazyStart;
    }

    @Nullable
    public Long createTime() {
        return this.createTime;
    }

    @Nullable
    public String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
        generator.writeKey("dest");
        this.dest.serialize(generator, mapper);
        generator.writeKey("analysis");
        this.analysis.serialize(generator, mapper);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.modelMemoryLimit != null) {
            generator.writeKey("model_memory_limit");
            generator.write(this.modelMemoryLimit);
        }
        if (this.maxNumThreads != null) {
            generator.writeKey("max_num_threads");
            generator.write(this.maxNumThreads.intValue());
        }
        if (this.analyzedFields != null) {
            generator.writeKey("analyzed_fields");
            generator.write(this.analyzedFields);
        }
        if (this.allowLazyStart != null) {
            generator.writeKey("allow_lazy_start");
            generator.write(this.allowLazyStart.booleanValue());
        }
        if (this.createTime != null) {
            generator.writeKey("create_time");
            generator.write(this.createTime.longValue());
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
    }

    protected static void setupDataframeAnalyticsSummaryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::source, DataframeAnalyticsSource._DESERIALIZER, "source", new String[0]);
        op.add(Builder::dest, DataframeAnalyticsDestination._DESERIALIZER, "dest", new String[0]);
        op.add(Builder::analysis, DataframeAnalysis._DESERIALIZER, "analysis", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::modelMemoryLimit, JsonpDeserializer.stringDeserializer(), "model_memory_limit", new String[0]);
        op.add(Builder::maxNumThreads, JsonpDeserializer.integerDeserializer(), "max_num_threads", new String[0]);
        op.add(Builder::analyzedFields, JsonpDeserializer.jsonValueDeserializer(), "analyzed_fields", new String[0]);
        op.add(Builder::allowLazyStart, JsonpDeserializer.booleanDeserializer(), "allow_lazy_start", new String[0]);
        op.add(Builder::createTime, JsonpDeserializer.longDeserializer(), "create_time", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalyticsSummary> {
        private String id;
        private DataframeAnalyticsSource source;
        private DataframeAnalyticsDestination dest;
        private DataframeAnalysis analysis;
        @Nullable
        private String description;
        @Nullable
        private String modelMemoryLimit;
        @Nullable
        private Integer maxNumThreads;
        @Nullable
        private JsonValue analyzedFields;
        @Nullable
        private Boolean allowLazyStart;
        @Nullable
        private Long createTime;
        @Nullable
        private String version;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder source(DataframeAnalyticsSource value) {
            this.source = value;
            return this;
        }

        public Builder source(Function<DataframeAnalyticsSource.Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
            return this.source(fn.apply(new DataframeAnalyticsSource.Builder()).build());
        }

        public Builder dest(DataframeAnalyticsDestination value) {
            this.dest = value;
            return this;
        }

        public Builder dest(Function<DataframeAnalyticsDestination.Builder, ObjectBuilder<DataframeAnalyticsDestination>> fn) {
            return this.dest(fn.apply(new DataframeAnalyticsDestination.Builder()).build());
        }

        public Builder analysis(DataframeAnalysis value) {
            this.analysis = value;
            return this;
        }

        public Builder analysis(Function<DataframeAnalysis.Builder, ObjectBuilder<DataframeAnalysis>> fn) {
            return this.analysis(fn.apply(new DataframeAnalysis.Builder()).build());
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder modelMemoryLimit(@Nullable String value) {
            this.modelMemoryLimit = value;
            return this;
        }

        public Builder maxNumThreads(@Nullable Integer value) {
            this.maxNumThreads = value;
            return this;
        }

        public Builder analyzedFields(@Nullable JsonValue value) {
            this.analyzedFields = value;
            return this;
        }

        public Builder allowLazyStart(@Nullable Boolean value) {
            this.allowLazyStart = value;
            return this;
        }

        public Builder createTime(@Nullable Long value) {
            this.createTime = value;
            return this;
        }

        public Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        @Override
        public DataframeAnalyticsSummary build() {
            return new DataframeAnalyticsSummary(this);
        }
    }
}

