/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class DataframeAnalyticsMemoryEstimation
implements JsonpSerializable {
    private final String expectedMemoryWithDisk;
    private final String expectedMemoryWithoutDisk;
    public static final JsonpDeserializer<DataframeAnalyticsMemoryEstimation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsMemoryEstimation::setupDataframeAnalyticsMemoryEstimationDeserializer, Builder::build);

    public DataframeAnalyticsMemoryEstimation(Builder builder) {
        this.expectedMemoryWithDisk = Objects.requireNonNull(builder.expectedMemoryWithDisk, "expected_memory_with_disk");
        this.expectedMemoryWithoutDisk = Objects.requireNonNull(builder.expectedMemoryWithoutDisk, "expected_memory_without_disk");
    }

    public DataframeAnalyticsMemoryEstimation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String expectedMemoryWithDisk() {
        return this.expectedMemoryWithDisk;
    }

    public String expectedMemoryWithoutDisk() {
        return this.expectedMemoryWithoutDisk;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expected_memory_with_disk");
        generator.write(this.expectedMemoryWithDisk);
        generator.writeKey("expected_memory_without_disk");
        generator.write(this.expectedMemoryWithoutDisk);
    }

    protected static void setupDataframeAnalyticsMemoryEstimationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::expectedMemoryWithDisk, JsonpDeserializer.stringDeserializer(), "expected_memory_with_disk", new String[0]);
        op.add(Builder::expectedMemoryWithoutDisk, JsonpDeserializer.stringDeserializer(), "expected_memory_without_disk", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<DataframeAnalyticsMemoryEstimation> {
        private String expectedMemoryWithDisk;
        private String expectedMemoryWithoutDisk;

        public Builder expectedMemoryWithDisk(String value) {
            this.expectedMemoryWithDisk = value;
            return this;
        }

        public Builder expectedMemoryWithoutDisk(String value) {
            this.expectedMemoryWithoutDisk = value;
            return this;
        }

        @Override
        public DataframeAnalyticsMemoryEstimation build() {
            return new DataframeAnalyticsMemoryEstimation(this);
        }
    }
}

