/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.ChunkingMode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ChunkingConfig
implements JsonpSerializable {
    private final ChunkingMode mode;
    @Nullable
    private final String timeSpan;
    public static final JsonpDeserializer<ChunkingConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChunkingConfig::setupChunkingConfigDeserializer, Builder::build);

    public ChunkingConfig(Builder builder) {
        this.mode = Objects.requireNonNull(builder.mode, "mode");
        this.timeSpan = builder.timeSpan;
    }

    public ChunkingConfig(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public ChunkingMode mode() {
        return this.mode;
    }

    @Nullable
    public String timeSpan() {
        return this.timeSpan;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        if (this.timeSpan != null) {
            generator.writeKey("time_span");
            generator.write(this.timeSpan);
        }
    }

    protected static void setupChunkingConfigDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::mode, ChunkingMode._DESERIALIZER, "mode", new String[0]);
        op.add(Builder::timeSpan, JsonpDeserializer.stringDeserializer(), "time_span", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ChunkingConfig> {
        private ChunkingMode mode;
        @Nullable
        private String timeSpan;

        public Builder mode(ChunkingMode value) {
            this.mode = value;
            return this;
        }

        public Builder timeSpan(@Nullable String value) {
            this.timeSpan = value;
            return this;
        }

        @Override
        public ChunkingConfig build() {
            return new ChunkingConfig(this);
        }
    }
}

