/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.logstash;

import co.elastic.clients.base.BooleanEndpoint;
import co.elastic.clients.base.BooleanResponse;
import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.logstash.Pipeline;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PutPipelineRequest
extends RequestBase
implements JsonpSerializable {
    private final String id;
    private final Pipeline pipeline;
    public static final JsonpDeserializer<PutPipelineRequest> _DESERIALIZER = PutPipelineRequest.createPutPipelineRequestDeserializer();
    public static final Endpoint<PutPipelineRequest, BooleanResponse, ElasticsearchError> ENDPOINT = new BooleanEndpoint<PutPipelineRequest>(request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_logstash");
            buf.append("/pipeline");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, (Function<PutPipelineRequest, Map<String, String>>)((Function<PutPipelineRequest, Map>)request -> Collections.emptyMap()), (Function<PutPipelineRequest, Map<String, String>>)SimpleEndpoint.emptyMap(), true, null);

    public PutPipelineRequest(Builder builder) {
        this.id = Objects.requireNonNull(builder.id, "id");
        this.pipeline = Objects.requireNonNull(builder.pipeline, "_value_body");
    }

    public PutPipelineRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String id() {
        return this.id;
    }

    public Pipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.pipeline.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutPipelineRequest> createPutPipelineRequestDeserializer() {
        JsonpDeserializer<Pipeline> valueDeserializer = Pipeline._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().pipeline((Pipeline)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<PutPipelineRequest> {
        private String id;
        private Pipeline pipeline;

        public Builder id(String value) {
            this.id = value;
            return this;
        }

        public Builder pipeline(Pipeline value) {
            this.pipeline = value;
            return this;
        }

        public Builder pipeline(Function<Pipeline.Builder, ObjectBuilder<Pipeline>> fn) {
            return this.pipeline(fn.apply(new Pipeline.Builder()).build());
        }

        @Override
        public PutPipelineRequest build() {
            return new PutPipelineRequest(this);
        }
    }
}

