/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.logstash;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PipelineSettings
implements JsonpSerializable {
    private final int pipelineWorkers;
    private final int pipelineBatchSize;
    private final int pipelineBatchDelay;
    private final String queueType;
    private final int queueMaxBytesNumber;
    private final String queueMaxBytesUnits;
    private final int queueCheckpointWrites;
    public static final JsonpDeserializer<PipelineSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineSettings::setupPipelineSettingsDeserializer, Builder::build);

    public PipelineSettings(Builder builder) {
        this.pipelineWorkers = Objects.requireNonNull(builder.pipelineWorkers, "pipeline.workers");
        this.pipelineBatchSize = Objects.requireNonNull(builder.pipelineBatchSize, "pipeline.batch.size");
        this.pipelineBatchDelay = Objects.requireNonNull(builder.pipelineBatchDelay, "pipeline.batch.delay");
        this.queueType = Objects.requireNonNull(builder.queueType, "queue.type");
        this.queueMaxBytesNumber = Objects.requireNonNull(builder.queueMaxBytesNumber, "queue.max_bytes.number");
        this.queueMaxBytesUnits = Objects.requireNonNull(builder.queueMaxBytesUnits, "queue.max_bytes.units");
        this.queueCheckpointWrites = Objects.requireNonNull(builder.queueCheckpointWrites, "queue.checkpoint.writes");
    }

    public PipelineSettings(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int pipelineWorkers() {
        return this.pipelineWorkers;
    }

    public int pipelineBatchSize() {
        return this.pipelineBatchSize;
    }

    public int pipelineBatchDelay() {
        return this.pipelineBatchDelay;
    }

    public String queueType() {
        return this.queueType;
    }

    public int queueMaxBytesNumber() {
        return this.queueMaxBytesNumber;
    }

    public String queueMaxBytesUnits() {
        return this.queueMaxBytesUnits;
    }

    public int queueCheckpointWrites() {
        return this.queueCheckpointWrites;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pipeline.workers");
        generator.write(this.pipelineWorkers);
        generator.writeKey("pipeline.batch.size");
        generator.write(this.pipelineBatchSize);
        generator.writeKey("pipeline.batch.delay");
        generator.write(this.pipelineBatchDelay);
        generator.writeKey("queue.type");
        generator.write(this.queueType);
        generator.writeKey("queue.max_bytes.number");
        generator.write(this.queueMaxBytesNumber);
        generator.writeKey("queue.max_bytes.units");
        generator.write(this.queueMaxBytesUnits);
        generator.writeKey("queue.checkpoint.writes");
        generator.write(this.queueCheckpointWrites);
    }

    protected static void setupPipelineSettingsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::pipelineWorkers, JsonpDeserializer.integerDeserializer(), "pipeline.workers", new String[0]);
        op.add(Builder::pipelineBatchSize, JsonpDeserializer.integerDeserializer(), "pipeline.batch.size", new String[0]);
        op.add(Builder::pipelineBatchDelay, JsonpDeserializer.integerDeserializer(), "pipeline.batch.delay", new String[0]);
        op.add(Builder::queueType, JsonpDeserializer.stringDeserializer(), "queue.type", new String[0]);
        op.add(Builder::queueMaxBytesNumber, JsonpDeserializer.integerDeserializer(), "queue.max_bytes.number", new String[0]);
        op.add(Builder::queueMaxBytesUnits, JsonpDeserializer.stringDeserializer(), "queue.max_bytes.units", new String[0]);
        op.add(Builder::queueCheckpointWrites, JsonpDeserializer.integerDeserializer(), "queue.checkpoint.writes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PipelineSettings> {
        private Integer pipelineWorkers;
        private Integer pipelineBatchSize;
        private Integer pipelineBatchDelay;
        private String queueType;
        private Integer queueMaxBytesNumber;
        private String queueMaxBytesUnits;
        private Integer queueCheckpointWrites;

        public Builder pipelineWorkers(int value) {
            this.pipelineWorkers = value;
            return this;
        }

        public Builder pipelineBatchSize(int value) {
            this.pipelineBatchSize = value;
            return this;
        }

        public Builder pipelineBatchDelay(int value) {
            this.pipelineBatchDelay = value;
            return this;
        }

        public Builder queueType(String value) {
            this.queueType = value;
            return this;
        }

        public Builder queueMaxBytesNumber(int value) {
            this.queueMaxBytesNumber = value;
            return this;
        }

        public Builder queueMaxBytesUnits(String value) {
            this.queueMaxBytesUnits = value;
            return this;
        }

        public Builder queueCheckpointWrites(int value) {
            this.queueCheckpointWrites = value;
            return this;
        }

        @Override
        public PipelineSettings build() {
            return new PipelineSettings(this);
        }
    }
}

