/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.license.PostStartTrialResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class PostStartTrialRequest
extends RequestBase {
    @Nullable
    private final Boolean acknowledge;
    @Nullable
    private final String typeQueryString;
    public static final Endpoint<PostStartTrialRequest, PostStartTrialResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PostStartTrialRequest, PostStartTrialResponse>(request -> "POST", request -> "/_license/start_trial", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.acknowledge != null) {
            params.put("acknowledge", String.valueOf(request.acknowledge));
        }
        if (request.typeQueryString != null) {
            params.put("type_query_string", request.typeQueryString);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, PostStartTrialResponse._DESERIALIZER);

    public PostStartTrialRequest(Builder builder) {
        this.acknowledge = builder.acknowledge;
        this.typeQueryString = builder.typeQueryString;
    }

    public PostStartTrialRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Boolean acknowledge() {
        return this.acknowledge;
    }

    @Nullable
    public String typeQueryString() {
        return this.typeQueryString;
    }

    public static class Builder
    implements ObjectBuilder<PostStartTrialRequest> {
        @Nullable
        private Boolean acknowledge;
        @Nullable
        private String typeQueryString;

        public Builder acknowledge(@Nullable Boolean value) {
            this.acknowledge = value;
            return this;
        }

        public Builder typeQueryString(@Nullable String value) {
            this.typeQueryString = value;
            return this;
        }

        @Override
        public PostStartTrialRequest build() {
            return new PostStartTrialRequest(this);
        }
    }
}

