/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.simulate;

import co.elastic.clients.elasticsearch.ingest.simulate.DocumentSimulation;
import co.elastic.clients.elasticsearch.watcher.ActionStatusOptions;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PipelineSimulation
implements JsonpSerializable {
    @Nullable
    private final DocumentSimulation doc;
    @Nullable
    private final List<PipelineSimulation> processorResults;
    @Nullable
    private final String tag;
    @Nullable
    private final String processorType;
    @Nullable
    private final ActionStatusOptions status;
    public static final JsonpDeserializer<PipelineSimulation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineSimulation::setupPipelineSimulationDeserializer, Builder::build);

    public PipelineSimulation(Builder builder) {
        this.doc = builder.doc;
        this.processorResults = ModelTypeHelper.unmodifiable(builder.processorResults);
        this.tag = builder.tag;
        this.processorType = builder.processorType;
        this.status = builder.status;
    }

    public PipelineSimulation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public DocumentSimulation doc() {
        return this.doc;
    }

    @Nullable
    public List<PipelineSimulation> processorResults() {
        return this.processorResults;
    }

    @Nullable
    public String tag() {
        return this.tag;
    }

    @Nullable
    public String processorType() {
        return this.processorType;
    }

    @Nullable
    public ActionStatusOptions status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (this.processorResults != null) {
            generator.writeKey("processor_results");
            generator.writeStartArray();
            for (PipelineSimulation item0 : this.processorResults) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
        if (this.processorType != null) {
            generator.writeKey("processor_type");
            generator.write(this.processorType);
        }
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
    }

    protected static void setupPipelineSimulationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::doc, DocumentSimulation._DESERIALIZER, "doc", new String[0]);
        op.add(Builder::processorResults, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "processor_results", new String[0]);
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag", new String[0]);
        op.add(Builder::processorType, JsonpDeserializer.stringDeserializer(), "processor_type", new String[0]);
        op.add(Builder::status, ActionStatusOptions._DESERIALIZER, "status", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PipelineSimulation> {
        @Nullable
        private DocumentSimulation doc;
        @Nullable
        private List<PipelineSimulation> processorResults;
        @Nullable
        private String tag;
        @Nullable
        private String processorType;
        @Nullable
        private ActionStatusOptions status;

        public Builder doc(@Nullable DocumentSimulation value) {
            this.doc = value;
            return this;
        }

        public Builder doc(Function<DocumentSimulation.Builder, ObjectBuilder<DocumentSimulation>> fn) {
            return this.doc(fn.apply(new DocumentSimulation.Builder()).build());
        }

        public Builder processorResults(@Nullable List<PipelineSimulation> value) {
            this.processorResults = value;
            return this;
        }

        public Builder processorResults(PipelineSimulation ... value) {
            this.processorResults = Arrays.asList(value);
            return this;
        }

        public Builder addProcessorResults(PipelineSimulation value) {
            if (this.processorResults == null) {
                this.processorResults = new ArrayList<PipelineSimulation>();
            }
            this.processorResults.add(value);
            return this;
        }

        public Builder processorResults(Function<Builder, ObjectBuilder<PipelineSimulation>> fn) {
            return this.processorResults(fn.apply(new Builder()).build());
        }

        public Builder addProcessorResults(Function<Builder, ObjectBuilder<PipelineSimulation>> fn) {
            return this.addProcessorResults(fn.apply(new Builder()).build());
        }

        public Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        public Builder processorType(@Nullable String value) {
            this.processorType = value;
            return this;
        }

        public Builder status(@Nullable ActionStatusOptions value) {
            this.status = value;
            return this;
        }

        @Override
        public PipelineSimulation build() {
            return new PipelineSimulation(this);
        }
    }
}

