/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.elasticsearch.ingest.UserAgentProperty;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class UserAgentProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final boolean ignoreMissing;
    private final List<UserAgentProperty> options;
    private final String regexFile;
    private final String targetField;
    public static final JsonpDeserializer<UserAgentProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserAgentProcessor::setupUserAgentProcessorDeserializer, Builder::build);

    public UserAgentProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.ignoreMissing = Objects.requireNonNull(builder.ignoreMissing, "ignore_missing");
        this.options = ModelTypeHelper.unmodifiableNonNull(builder.options, "options");
        this.regexFile = Objects.requireNonNull(builder.regexFile, "regex_file");
        this.targetField = Objects.requireNonNull(builder.targetField, "target_field");
    }

    public UserAgentProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "user_agent";
    }

    public String field() {
        return this.field;
    }

    public boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public List<UserAgentProperty> options() {
        return this.options;
    }

    public String regexFile() {
        return this.regexFile;
    }

    public String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("ignore_missing");
        generator.write(this.ignoreMissing);
        generator.writeKey("options");
        generator.writeStartArray();
        for (UserAgentProperty item0 : this.options) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("regex_file");
        generator.write(this.regexFile);
        generator.writeKey("target_field");
        generator.write(this.targetField);
    }

    protected static void setupUserAgentProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::options, JsonpDeserializer.arrayDeserializer(UserAgentProperty._DESERIALIZER), "options", new String[0]);
        op.add(Builder::regexFile, JsonpDeserializer.stringDeserializer(), "regex_file", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UserAgentProcessor> {
        private String field;
        private Boolean ignoreMissing;
        private List<UserAgentProperty> options;
        private String regexFile;
        private String targetField;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder ignoreMissing(boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder options(List<UserAgentProperty> value) {
            this.options = value;
            return this;
        }

        public Builder options(UserAgentProperty ... value) {
            this.options = Arrays.asList(value);
            return this;
        }

        public Builder addOptions(UserAgentProperty value) {
            if (this.options == null) {
                this.options = new ArrayList<UserAgentProperty>();
            }
            this.options.add(value);
            return this;
        }

        public Builder regexFile(String value) {
            this.regexFile = value;
            return this;
        }

        public Builder targetField(String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserAgentProcessor build() {
            return new UserAgentProcessor(this);
        }
    }
}

