/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RemoveProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final List<String> field;
    @Nullable
    private final Boolean ignoreMissing;
    public static final JsonpDeserializer<RemoveProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoveProcessor::setupRemoveProcessorDeserializer, Builder::build);

    public RemoveProcessor(Builder builder) {
        super(builder);
        this.field = ModelTypeHelper.unmodifiableNonNull(builder.field, "field");
        this.ignoreMissing = builder.ignoreMissing;
    }

    public RemoveProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "remove";
    }

    public List<String> field() {
        return this.field;
    }

    @Nullable
    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.writeStartArray();
        for (String item0 : this.field) {
            generator.write(item0);
        }
        generator.writeEnd();
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
    }

    protected static void setupRemoveProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "field", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RemoveProcessor> {
        private List<String> field;
        @Nullable
        private Boolean ignoreMissing;

        public Builder field(List<String> value) {
            this.field = value;
            return this;
        }

        public Builder field(String ... value) {
            this.field = Arrays.asList(value);
            return this;
        }

        public Builder addField(String value) {
            if (this.field == null) {
                this.field = new ArrayList<String>();
            }
            this.field.add(value);
            return this;
        }

        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoveProcessor build() {
            return new RemoveProcessor(this);
        }
    }
}

