/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class KeyValueProcessor
extends ProcessorBase
implements ProcessorVariant {
    @Nullable
    private final List<String> excludeKeys;
    private final String field;
    private final String fieldSplit;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final List<String> includeKeys;
    @Nullable
    private final String prefix;
    @Nullable
    private final Boolean stripBrackets;
    @Nullable
    private final String targetField;
    @Nullable
    private final String trimKey;
    @Nullable
    private final String trimValue;
    private final String valueSplit;
    public static final JsonpDeserializer<KeyValueProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeyValueProcessor::setupKeyValueProcessorDeserializer, Builder::build);

    public KeyValueProcessor(Builder builder) {
        super(builder);
        this.excludeKeys = ModelTypeHelper.unmodifiable(builder.excludeKeys);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.fieldSplit = Objects.requireNonNull(builder.fieldSplit, "field_split");
        this.ignoreMissing = builder.ignoreMissing;
        this.includeKeys = ModelTypeHelper.unmodifiable(builder.includeKeys);
        this.prefix = builder.prefix;
        this.stripBrackets = builder.stripBrackets;
        this.targetField = builder.targetField;
        this.trimKey = builder.trimKey;
        this.trimValue = builder.trimValue;
        this.valueSplit = Objects.requireNonNull(builder.valueSplit, "value_split");
    }

    public KeyValueProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "kv";
    }

    @Nullable
    public List<String> excludeKeys() {
        return this.excludeKeys;
    }

    public String field() {
        return this.field;
    }

    public String fieldSplit() {
        return this.fieldSplit;
    }

    @Nullable
    public Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public List<String> includeKeys() {
        return this.includeKeys;
    }

    @Nullable
    public String prefix() {
        return this.prefix;
    }

    @Nullable
    public Boolean stripBrackets() {
        return this.stripBrackets;
    }

    @Nullable
    public String targetField() {
        return this.targetField;
    }

    @Nullable
    public String trimKey() {
        return this.trimKey;
    }

    @Nullable
    public String trimValue() {
        return this.trimValue;
    }

    public String valueSplit() {
        return this.valueSplit;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.excludeKeys != null) {
            generator.writeKey("exclude_keys");
            generator.writeStartArray();
            for (String item0 : this.excludeKeys) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("field_split");
        generator.write(this.fieldSplit);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (this.includeKeys != null) {
            generator.writeKey("include_keys");
            generator.writeStartArray();
            for (String item0 : this.includeKeys) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.prefix != null) {
            generator.writeKey("prefix");
            generator.write(this.prefix);
        }
        if (this.stripBrackets != null) {
            generator.writeKey("strip_brackets");
            generator.write(this.stripBrackets.booleanValue());
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.trimKey != null) {
            generator.writeKey("trim_key");
            generator.write(this.trimKey);
        }
        if (this.trimValue != null) {
            generator.writeKey("trim_value");
            generator.write(this.trimValue);
        }
        generator.writeKey("value_split");
        generator.write(this.valueSplit);
    }

    protected static void setupKeyValueProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::excludeKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "exclude_keys", new String[0]);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::fieldSplit, JsonpDeserializer.stringDeserializer(), "field_split", new String[0]);
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing", new String[0]);
        op.add(Builder::includeKeys, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "include_keys", new String[0]);
        op.add(Builder::prefix, JsonpDeserializer.stringDeserializer(), "prefix", new String[0]);
        op.add(Builder::stripBrackets, JsonpDeserializer.booleanDeserializer(), "strip_brackets", new String[0]);
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field", new String[0]);
        op.add(Builder::trimKey, JsonpDeserializer.stringDeserializer(), "trim_key", new String[0]);
        op.add(Builder::trimValue, JsonpDeserializer.stringDeserializer(), "trim_value", new String[0]);
        op.add(Builder::valueSplit, JsonpDeserializer.stringDeserializer(), "value_split", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeyValueProcessor> {
        @Nullable
        private List<String> excludeKeys;
        private String field;
        private String fieldSplit;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private List<String> includeKeys;
        @Nullable
        private String prefix;
        @Nullable
        private Boolean stripBrackets;
        @Nullable
        private String targetField;
        @Nullable
        private String trimKey;
        @Nullable
        private String trimValue;
        private String valueSplit;

        public Builder excludeKeys(@Nullable List<String> value) {
            this.excludeKeys = value;
            return this;
        }

        public Builder excludeKeys(String ... value) {
            this.excludeKeys = Arrays.asList(value);
            return this;
        }

        public Builder addExcludeKeys(String value) {
            if (this.excludeKeys == null) {
                this.excludeKeys = new ArrayList<String>();
            }
            this.excludeKeys.add(value);
            return this;
        }

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder fieldSplit(String value) {
            this.fieldSplit = value;
            return this;
        }

        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public Builder includeKeys(@Nullable List<String> value) {
            this.includeKeys = value;
            return this;
        }

        public Builder includeKeys(String ... value) {
            this.includeKeys = Arrays.asList(value);
            return this;
        }

        public Builder addIncludeKeys(String value) {
            if (this.includeKeys == null) {
                this.includeKeys = new ArrayList<String>();
            }
            this.includeKeys.add(value);
            return this;
        }

        public Builder prefix(@Nullable String value) {
            this.prefix = value;
            return this;
        }

        public Builder stripBrackets(@Nullable Boolean value) {
            this.stripBrackets = value;
            return this;
        }

        public Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public Builder trimKey(@Nullable String value) {
            this.trimKey = value;
            return this;
        }

        public Builder trimValue(@Nullable String value) {
            this.trimValue = value;
            return this;
        }

        public Builder valueSplit(String value) {
            this.valueSplit = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeyValueProcessor build() {
            return new KeyValueProcessor(this);
        }
    }
}

