/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class AppendProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final List<JsonData> value;
    @Nullable
    private final Boolean allowDuplicates;
    public static final JsonpDeserializer<AppendProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AppendProcessor::setupAppendProcessorDeserializer, Builder::build);

    public AppendProcessor(Builder builder) {
        super(builder);
        this.field = Objects.requireNonNull(builder.field, "field");
        this.value = ModelTypeHelper.unmodifiableNonNull(builder.value, "value");
        this.allowDuplicates = builder.allowDuplicates;
    }

    public AppendProcessor(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "append";
    }

    public String field() {
        return this.field;
    }

    public List<JsonData> value() {
        return this.value;
    }

    @Nullable
    public Boolean allowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("value");
        generator.writeStartArray();
        for (JsonData item0 : this.value) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.allowDuplicates != null) {
            generator.writeKey("allow_duplicates");
            generator.write(this.allowDuplicates.booleanValue());
        }
    }

    protected static void setupAppendProcessorDeserializer(DelegatingDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field", new String[0]);
        op.add(Builder::value, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "value", new String[0]);
        op.add(Builder::allowDuplicates, JsonpDeserializer.booleanDeserializer(), "allow_duplicates", new String[0]);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AppendProcessor> {
        private String field;
        private List<JsonData> value;
        @Nullable
        private Boolean allowDuplicates;

        public Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder value(List<JsonData> value) {
            this.value = value;
            return this;
        }

        public Builder value(JsonData ... value) {
            this.value = Arrays.asList(value);
            return this;
        }

        public Builder addValue(JsonData value) {
            if (this.value == null) {
                this.value = new ArrayList<JsonData>();
            }
            this.value.add(value);
            return this;
        }

        public Builder allowDuplicates(@Nullable Boolean value) {
            this.allowDuplicates = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AppendProcessor build() {
            return new AppendProcessor(this);
        }
    }
}

