/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.validate_query;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndicesValidationExplanation
implements JsonpSerializable {
    @Nullable
    private final String error;
    @Nullable
    private final String explanation;
    private final String index;
    private final boolean valid;
    public static final JsonpDeserializer<IndicesValidationExplanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesValidationExplanation::setupIndicesValidationExplanationDeserializer, Builder::build);

    public IndicesValidationExplanation(Builder builder) {
        this.error = builder.error;
        this.explanation = builder.explanation;
        this.index = Objects.requireNonNull(builder.index, "index");
        this.valid = Objects.requireNonNull(builder.valid, "valid");
    }

    public IndicesValidationExplanation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String error() {
        return this.error;
    }

    @Nullable
    public String explanation() {
        return this.explanation;
    }

    public String index() {
        return this.index;
    }

    public boolean valid() {
        return this.valid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
        if (this.explanation != null) {
            generator.writeKey("explanation");
            generator.write(this.explanation);
        }
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("valid");
        generator.write(this.valid);
    }

    protected static void setupIndicesValidationExplanationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error", new String[0]);
        op.add(Builder::explanation, JsonpDeserializer.stringDeserializer(), "explanation", new String[0]);
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index", new String[0]);
        op.add(Builder::valid, JsonpDeserializer.booleanDeserializer(), "valid", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndicesValidationExplanation> {
        @Nullable
        private String error;
        @Nullable
        private String explanation;
        private String index;
        private Boolean valid;

        public Builder error(@Nullable String value) {
            this.error = value;
            return this;
        }

        public Builder explanation(@Nullable String value) {
            this.explanation = value;
            return this;
        }

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder valid(boolean value) {
            this.valid = value;
            return this;
        }

        @Override
        public IndicesValidationExplanation build() {
            return new IndicesValidationExplanation(this);
        }
    }
}

