/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ShardSequenceNumber
implements JsonpSerializable {
    private final long globalCheckpoint;
    private final long localCheckpoint;
    private final int maxSeqNo;
    public static final JsonpDeserializer<ShardSequenceNumber> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSequenceNumber::setupShardSequenceNumberDeserializer, Builder::build);

    public ShardSequenceNumber(Builder builder) {
        this.globalCheckpoint = Objects.requireNonNull(builder.globalCheckpoint, "global_checkpoint");
        this.localCheckpoint = Objects.requireNonNull(builder.localCheckpoint, "local_checkpoint");
        this.maxSeqNo = Objects.requireNonNull(builder.maxSeqNo, "max_seq_no");
    }

    public ShardSequenceNumber(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long globalCheckpoint() {
        return this.globalCheckpoint;
    }

    public long localCheckpoint() {
        return this.localCheckpoint;
    }

    public int maxSeqNo() {
        return this.maxSeqNo;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("global_checkpoint");
        generator.write(this.globalCheckpoint);
        generator.writeKey("local_checkpoint");
        generator.write(this.localCheckpoint);
        generator.writeKey("max_seq_no");
        generator.write(this.maxSeqNo);
    }

    protected static void setupShardSequenceNumberDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::globalCheckpoint, JsonpDeserializer.longDeserializer(), "global_checkpoint", new String[0]);
        op.add(Builder::localCheckpoint, JsonpDeserializer.longDeserializer(), "local_checkpoint", new String[0]);
        op.add(Builder::maxSeqNo, JsonpDeserializer.integerDeserializer(), "max_seq_no", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ShardSequenceNumber> {
        private Long globalCheckpoint;
        private Long localCheckpoint;
        private Integer maxSeqNo;

        public Builder globalCheckpoint(long value) {
            this.globalCheckpoint = value;
            return this;
        }

        public Builder localCheckpoint(long value) {
            this.localCheckpoint = value;
            return this;
        }

        public Builder maxSeqNo(int value) {
            this.maxSeqNo = value;
            return this;
        }

        @Override
        public ShardSequenceNumber build() {
            return new ShardSequenceNumber(this);
        }
    }
}

