/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.shard_stores;

import co.elastic.clients.elasticsearch.indices.shard_stores.ShardStoreWrapper;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class IndicesShardStores
implements JsonpSerializable {
    private final Map<String, ShardStoreWrapper> shards;
    public static final JsonpDeserializer<IndicesShardStores> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesShardStores::setupIndicesShardStoresDeserializer, Builder::build);

    public IndicesShardStores(Builder builder) {
        this.shards = ModelTypeHelper.unmodifiableNonNull(builder.shards, "shards");
    }

    public IndicesShardStores(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, ShardStoreWrapper> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("shards");
        generator.writeStartObject();
        for (Map.Entry<String, ShardStoreWrapper> item0 : this.shards.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupIndicesShardStoresDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(ShardStoreWrapper._DESERIALIZER), "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndicesShardStores> {
        private Map<String, ShardStoreWrapper> shards;

        public Builder shards(Map<String, ShardStoreWrapper> value) {
            this.shards = value;
            return this;
        }

        public Builder putShards(String key, ShardStoreWrapper value) {
            if (this.shards == null) {
                this.shards = new HashMap<String, ShardStoreWrapper>();
            }
            this.shards.put(key, value);
            return this;
        }

        public Builder shards(String key, Function<ShardStoreWrapper.Builder, ObjectBuilder<ShardStoreWrapper>> fn) {
            return this.shards(Collections.singletonMap(key, fn.apply(new ShardStoreWrapper.Builder()).build()));
        }

        public Builder putShards(String key, Function<ShardStoreWrapper.Builder, ObjectBuilder<ShardStoreWrapper>> fn) {
            return this.putShards(key, fn.apply(new ShardStoreWrapper.Builder()).build());
        }

        @Override
        public IndicesShardStores build() {
            return new IndicesShardStores(this);
        }
    }
}

