/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.segments;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Segment
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final boolean committed;
    private final boolean compound;
    private final long deletedDocs;
    private final int generation;
    private final double memoryInBytes;
    private final boolean search;
    private final double sizeInBytes;
    private final long numDocs;
    private final String version;
    public static final JsonpDeserializer<Segment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Segment::setupSegmentDeserializer, Builder::build);

    public Segment(Builder builder) {
        this.attributes = ModelTypeHelper.unmodifiableNonNull(builder.attributes, "attributes");
        this.committed = Objects.requireNonNull(builder.committed, "committed");
        this.compound = Objects.requireNonNull(builder.compound, "compound");
        this.deletedDocs = Objects.requireNonNull(builder.deletedDocs, "deleted_docs");
        this.generation = Objects.requireNonNull(builder.generation, "generation");
        this.memoryInBytes = Objects.requireNonNull(builder.memoryInBytes, "memory_in_bytes");
        this.search = Objects.requireNonNull(builder.search, "search");
        this.sizeInBytes = Objects.requireNonNull(builder.sizeInBytes, "size_in_bytes");
        this.numDocs = Objects.requireNonNull(builder.numDocs, "num_docs");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public Segment(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public boolean committed() {
        return this.committed;
    }

    public boolean compound() {
        return this.compound;
    }

    public long deletedDocs() {
        return this.deletedDocs;
    }

    public int generation() {
        return this.generation;
    }

    public double memoryInBytes() {
        return this.memoryInBytes;
    }

    public boolean search() {
        return this.search;
    }

    public double sizeInBytes() {
        return this.sizeInBytes;
    }

    public long numDocs() {
        return this.numDocs;
    }

    public String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry<String, String> item0 : this.attributes.entrySet()) {
            generator.writeKey(item0.getKey());
            generator.write(item0.getValue());
        }
        generator.writeEnd();
        generator.writeKey("committed");
        generator.write(this.committed);
        generator.writeKey("compound");
        generator.write(this.compound);
        generator.writeKey("deleted_docs");
        generator.write(this.deletedDocs);
        generator.writeKey("generation");
        generator.write(this.generation);
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes);
        generator.writeKey("search");
        generator.write(this.search);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
        generator.writeKey("num_docs");
        generator.write(this.numDocs);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupSegmentDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes", new String[0]);
        op.add(Builder::committed, JsonpDeserializer.booleanDeserializer(), "committed", new String[0]);
        op.add(Builder::compound, JsonpDeserializer.booleanDeserializer(), "compound", new String[0]);
        op.add(Builder::deletedDocs, JsonpDeserializer.longDeserializer(), "deleted_docs", new String[0]);
        op.add(Builder::generation, JsonpDeserializer.integerDeserializer(), "generation", new String[0]);
        op.add(Builder::memoryInBytes, JsonpDeserializer.doubleDeserializer(), "memory_in_bytes", new String[0]);
        op.add(Builder::search, JsonpDeserializer.booleanDeserializer(), "search", new String[0]);
        op.add(Builder::sizeInBytes, JsonpDeserializer.doubleDeserializer(), "size_in_bytes", new String[0]);
        op.add(Builder::numDocs, JsonpDeserializer.longDeserializer(), "num_docs", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Segment> {
        private Map<String, String> attributes;
        private Boolean committed;
        private Boolean compound;
        private Long deletedDocs;
        private Integer generation;
        private Double memoryInBytes;
        private Boolean search;
        private Double sizeInBytes;
        private Long numDocs;
        private String version;

        public Builder attributes(Map<String, String> value) {
            this.attributes = value;
            return this;
        }

        public Builder putAttributes(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder committed(boolean value) {
            this.committed = value;
            return this;
        }

        public Builder compound(boolean value) {
            this.compound = value;
            return this;
        }

        public Builder deletedDocs(long value) {
            this.deletedDocs = value;
            return this;
        }

        public Builder generation(int value) {
            this.generation = value;
            return this;
        }

        public Builder memoryInBytes(double value) {
            this.memoryInBytes = value;
            return this;
        }

        public Builder search(boolean value) {
            this.search = value;
            return this;
        }

        public Builder sizeInBytes(double value) {
            this.sizeInBytes = value;
            return this;
        }

        public Builder numDocs(long value) {
            this.numDocs = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        public Segment build() {
            return new Segment(this);
        }
    }
}

