/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.rollover;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class RolloverConditions
implements JsonpSerializable {
    @Nullable
    private final String maxAge;
    @Nullable
    private final Long maxDocs;
    @Nullable
    private final String maxSize;
    @Nullable
    private final String maxPrimaryShardSize;
    public static final JsonpDeserializer<RolloverConditions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RolloverConditions::setupRolloverConditionsDeserializer, Builder::build);

    public RolloverConditions(Builder builder) {
        this.maxAge = builder.maxAge;
        this.maxDocs = builder.maxDocs;
        this.maxSize = builder.maxSize;
        this.maxPrimaryShardSize = builder.maxPrimaryShardSize;
    }

    public RolloverConditions(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String maxAge() {
        return this.maxAge;
    }

    @Nullable
    public Long maxDocs() {
        return this.maxDocs;
    }

    @Nullable
    public String maxSize() {
        return this.maxSize;
    }

    @Nullable
    public String maxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxAge != null) {
            generator.writeKey("max_age");
            generator.write(this.maxAge);
        }
        if (this.maxDocs != null) {
            generator.writeKey("max_docs");
            generator.write(this.maxDocs.longValue());
        }
        if (this.maxSize != null) {
            generator.writeKey("max_size");
            generator.write(this.maxSize);
        }
        if (this.maxPrimaryShardSize != null) {
            generator.writeKey("max_primary_shard_size");
            generator.write(this.maxPrimaryShardSize);
        }
    }

    protected static void setupRolloverConditionsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::maxAge, JsonpDeserializer.stringDeserializer(), "max_age", new String[0]);
        op.add(Builder::maxDocs, JsonpDeserializer.longDeserializer(), "max_docs", new String[0]);
        op.add(Builder::maxSize, JsonpDeserializer.stringDeserializer(), "max_size", new String[0]);
        op.add(Builder::maxPrimaryShardSize, JsonpDeserializer.stringDeserializer(), "max_primary_shard_size", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RolloverConditions> {
        @Nullable
        private String maxAge;
        @Nullable
        private Long maxDocs;
        @Nullable
        private String maxSize;
        @Nullable
        private String maxPrimaryShardSize;

        public Builder maxAge(@Nullable String value) {
            this.maxAge = value;
            return this;
        }

        public Builder maxDocs(@Nullable Long value) {
            this.maxDocs = value;
            return this;
        }

        public Builder maxSize(@Nullable String value) {
            this.maxSize = value;
            return this;
        }

        public Builder maxPrimaryShardSize(@Nullable String value) {
            this.maxPrimaryShardSize = value;
            return this;
        }

        @Override
        public RolloverConditions build() {
            return new RolloverConditions(this);
        }
    }
}

