/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class VerifyIndex
implements JsonpSerializable {
    @Nullable
    private final String checkIndexTime;
    private final String checkIndexTimeInMillis;
    @Nullable
    private final String totalTime;
    private final String totalTimeInMillis;
    public static final JsonpDeserializer<VerifyIndex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VerifyIndex::setupVerifyIndexDeserializer, Builder::build);

    public VerifyIndex(Builder builder) {
        this.checkIndexTime = builder.checkIndexTime;
        this.checkIndexTimeInMillis = Objects.requireNonNull(builder.checkIndexTimeInMillis, "check_index_time_in_millis");
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = Objects.requireNonNull(builder.totalTimeInMillis, "total_time_in_millis");
    }

    public VerifyIndex(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String checkIndexTime() {
        return this.checkIndexTime;
    }

    public String checkIndexTimeInMillis() {
        return this.checkIndexTimeInMillis;
    }

    @Nullable
    public String totalTime() {
        return this.totalTime;
    }

    public String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.checkIndexTime != null) {
            generator.writeKey("check_index_time");
            generator.write(this.checkIndexTime);
        }
        generator.writeKey("check_index_time_in_millis");
        generator.write(this.checkIndexTimeInMillis);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            generator.write(this.totalTime);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupVerifyIndexDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::checkIndexTime, JsonpDeserializer.stringDeserializer(), "check_index_time", new String[0]);
        op.add(Builder::checkIndexTimeInMillis, JsonpDeserializer.stringDeserializer(), "check_index_time_in_millis", new String[0]);
        op.add(Builder::totalTime, JsonpDeserializer.stringDeserializer(), "total_time", new String[0]);
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<VerifyIndex> {
        @Nullable
        private String checkIndexTime;
        private String checkIndexTimeInMillis;
        @Nullable
        private String totalTime;
        private String totalTimeInMillis;

        public Builder checkIndexTime(@Nullable String value) {
            this.checkIndexTime = value;
            return this;
        }

        public Builder checkIndexTimeInMillis(String value) {
            this.checkIndexTimeInMillis = value;
            return this;
        }

        public Builder totalTime(@Nullable String value) {
            this.totalTime = value;
            return this;
        }

        public Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        public VerifyIndex build() {
            return new VerifyIndex(this);
        }
    }
}

