/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.elasticsearch.indices.recovery.ShardRecovery;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class RecoveryStatus
implements JsonpSerializable {
    private final List<ShardRecovery> shards;
    public static final JsonpDeserializer<RecoveryStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryStatus::setupRecoveryStatusDeserializer, Builder::build);

    public RecoveryStatus(Builder builder) {
        this.shards = ModelTypeHelper.unmodifiableNonNull(builder.shards, "shards");
    }

    public RecoveryStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ShardRecovery> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("shards");
        generator.writeStartArray();
        for (ShardRecovery item0 : this.shards) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupRecoveryStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.arrayDeserializer(ShardRecovery._DESERIALIZER), "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RecoveryStatus> {
        private List<ShardRecovery> shards;

        public Builder shards(List<ShardRecovery> value) {
            this.shards = value;
            return this;
        }

        public Builder shards(ShardRecovery ... value) {
            this.shards = Arrays.asList(value);
            return this;
        }

        public Builder addShards(ShardRecovery value) {
            if (this.shards == null) {
                this.shards = new ArrayList<ShardRecovery>();
            }
            this.shards.add(value);
            return this;
        }

        public Builder shards(Function<ShardRecovery.Builder, ObjectBuilder<ShardRecovery>> fn) {
            return this.shards(fn.apply(new ShardRecovery.Builder()).build());
        }

        public Builder addShards(Function<ShardRecovery.Builder, ObjectBuilder<ShardRecovery>> fn) {
            return this.addShards(fn.apply(new ShardRecovery.Builder()).build());
        }

        @Override
        public RecoveryStatus build() {
            return new RecoveryStatus(this);
        }
    }
}

