/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.recovery;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RecoveryStartStatus
implements JsonpSerializable {
    private final long checkIndexTime;
    private final String totalTimeInMillis;
    public static final JsonpDeserializer<RecoveryStartStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RecoveryStartStatus::setupRecoveryStartStatusDeserializer, Builder::build);

    public RecoveryStartStatus(Builder builder) {
        this.checkIndexTime = Objects.requireNonNull(builder.checkIndexTime, "check_index_time");
        this.totalTimeInMillis = Objects.requireNonNull(builder.totalTimeInMillis, "total_time_in_millis");
    }

    public RecoveryStartStatus(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long checkIndexTime() {
        return this.checkIndexTime;
    }

    public String totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("check_index_time");
        generator.write(this.checkIndexTime);
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    protected static void setupRecoveryStartStatusDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::checkIndexTime, JsonpDeserializer.longDeserializer(), "check_index_time", new String[0]);
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.stringDeserializer(), "total_time_in_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RecoveryStartStatus> {
        private Long checkIndexTime;
        private String totalTimeInMillis;

        public Builder checkIndexTime(long value) {
            this.checkIndexTime = value;
            return this;
        }

        public Builder totalTimeInMillis(String value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        public RecoveryStartStatus build() {
            return new RecoveryStartStatus(this);
        }
    }
}

