/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_mapping;

import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexMappingRecord
implements JsonpSerializable {
    @Nullable
    private final TypeMapping item;
    private final TypeMapping mappings;
    public static final JsonpDeserializer<IndexMappingRecord> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexMappingRecord::setupIndexMappingRecordDeserializer, Builder::build);

    public IndexMappingRecord(Builder builder) {
        this.item = builder.item;
        this.mappings = Objects.requireNonNull(builder.mappings, "mappings");
    }

    public IndexMappingRecord(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public TypeMapping item() {
        return this.item;
    }

    public TypeMapping mappings() {
        return this.mappings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.item != null) {
            generator.writeKey("item");
            this.item.serialize(generator, mapper);
        }
        generator.writeKey("mappings");
        this.mappings.serialize(generator, mapper);
    }

    protected static void setupIndexMappingRecordDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::item, TypeMapping._DESERIALIZER, "item", new String[0]);
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexMappingRecord> {
        @Nullable
        private TypeMapping item;
        private TypeMapping mappings;

        public Builder item(@Nullable TypeMapping value) {
            this.item = value;
            return this;
        }

        public Builder item(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.item(fn.apply(new TypeMapping.Builder()).build());
        }

        public Builder mappings(TypeMapping value) {
            this.mappings = value;
            return this;
        }

        public Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Override
        public IndexMappingRecord build() {
            return new IndexMappingRecord(this);
        }
    }
}

