/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_alias;

import co.elastic.clients.elasticsearch.indices.AliasDefinition;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public final class IndexAliases
implements JsonpSerializable {
    private final Map<String, AliasDefinition> aliases;
    public static final JsonpDeserializer<IndexAliases> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexAliases::setupIndexAliasesDeserializer, Builder::build);

    public IndexAliases(Builder builder) {
        this.aliases = ModelTypeHelper.unmodifiableNonNull(builder.aliases, "aliases");
    }

    public IndexAliases(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, AliasDefinition> aliases() {
        return this.aliases;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aliases");
        generator.writeStartObject();
        for (Map.Entry<String, AliasDefinition> item0 : this.aliases.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupIndexAliasesDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(AliasDefinition._DESERIALIZER), "aliases", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexAliases> {
        private Map<String, AliasDefinition> aliases;

        public Builder aliases(Map<String, AliasDefinition> value) {
            this.aliases = value;
            return this;
        }

        public Builder putAliases(String key, AliasDefinition value) {
            if (this.aliases == null) {
                this.aliases = new HashMap<String, AliasDefinition>();
            }
            this.aliases.put(key, value);
            return this;
        }

        public Builder aliases(String key, Function<AliasDefinition.Builder, ObjectBuilder<AliasDefinition>> fn) {
            return this.aliases(Collections.singletonMap(key, fn.apply(new AliasDefinition.Builder()).build()));
        }

        public Builder putAliases(String key, Function<AliasDefinition.Builder, ObjectBuilder<AliasDefinition>> fn) {
            return this.putAliases(key, fn.apply(new AliasDefinition.Builder()).build());
        }

        @Override
        public IndexAliases build() {
            return new IndexAliases(this);
        }
    }
}

