/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.close;

import co.elastic.clients.elasticsearch._types.ShardFailure;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public final class CloseShardResult
implements JsonpSerializable {
    private final List<ShardFailure> failures;
    public static final JsonpDeserializer<CloseShardResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloseShardResult::setupCloseShardResultDeserializer, Builder::build);

    public CloseShardResult(Builder builder) {
        this.failures = ModelTypeHelper.unmodifiableNonNull(builder.failures, "failures");
    }

    public CloseShardResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ShardFailure> failures() {
        return this.failures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failures");
        generator.writeStartArray();
        for (ShardFailure item0 : this.failures) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupCloseShardResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::failures, JsonpDeserializer.arrayDeserializer(ShardFailure._DESERIALIZER), "failures", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CloseShardResult> {
        private List<ShardFailure> failures;

        public Builder failures(List<ShardFailure> value) {
            this.failures = value;
            return this;
        }

        public Builder failures(ShardFailure ... value) {
            this.failures = Arrays.asList(value);
            return this;
        }

        public Builder addFailures(ShardFailure value) {
            if (this.failures == null) {
                this.failures = new ArrayList<ShardFailure>();
            }
            this.failures.add(value);
            return this;
        }

        public Builder failures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.failures(fn.apply(new ShardFailure.Builder()).build());
        }

        public Builder addFailures(Function<ShardFailure.Builder, ObjectBuilder<ShardFailure>> fn) {
            return this.addFailures(fn.apply(new ShardFailure.Builder()).build());
        }

        @Override
        public CloseShardResult build() {
            return new CloseShardResult(this);
        }
    }
}

