/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.close;

import co.elastic.clients.elasticsearch.indices.close.CloseShardResult;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class CloseIndexResult
implements JsonpSerializable {
    private final boolean closed;
    @Nullable
    private final Map<String, CloseShardResult> shards;
    public static final JsonpDeserializer<CloseIndexResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloseIndexResult::setupCloseIndexResultDeserializer, Builder::build);

    public CloseIndexResult(Builder builder) {
        this.closed = Objects.requireNonNull(builder.closed, "closed");
        this.shards = ModelTypeHelper.unmodifiable(builder.shards);
    }

    public CloseIndexResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean closed() {
        return this.closed;
    }

    @Nullable
    public Map<String, CloseShardResult> shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("closed");
        generator.write(this.closed);
        if (this.shards != null) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, CloseShardResult> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupCloseIndexResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::closed, JsonpDeserializer.booleanDeserializer(), "closed", new String[0]);
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(CloseShardResult._DESERIALIZER), "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CloseIndexResult> {
        private Boolean closed;
        @Nullable
        private Map<String, CloseShardResult> shards;

        public Builder closed(boolean value) {
            this.closed = value;
            return this;
        }

        public Builder shards(@Nullable Map<String, CloseShardResult> value) {
            this.shards = value;
            return this;
        }

        public Builder putShards(String key, CloseShardResult value) {
            if (this.shards == null) {
                this.shards = new HashMap<String, CloseShardResult>();
            }
            this.shards.put(key, value);
            return this;
        }

        public Builder shards(String key, Function<CloseShardResult.Builder, ObjectBuilder<CloseShardResult>> fn) {
            return this.shards(Collections.singletonMap(key, fn.apply(new CloseShardResult.Builder()).build()));
        }

        public Builder putShards(String key, Function<CloseShardResult.Builder, ObjectBuilder<CloseShardResult>> fn) {
            return this.putShards(key, fn.apply(new CloseShardResult.Builder()).build());
        }

        @Override
        public CloseIndexResult build() {
            return new CloseIndexResult(this);
        }
    }
}

