/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.DefaultOperator;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.indices.ValidateQueryResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ValidateQueryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> index;
    @Nullable
    private final List<String> type;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean allShards;
    @Nullable
    private final String analyzer;
    @Nullable
    private final Boolean analyzeWildcard;
    @Nullable
    private final DefaultOperator defaultOperator;
    @Nullable
    private final String df;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean lenient;
    @Nullable
    private final Boolean rewrite;
    @Nullable
    private final String q;
    @Nullable
    private final Query query;
    public static final JsonpDeserializer<ValidateQueryRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ValidateQueryRequest::setupValidateQueryRequestDeserializer, Builder::build);
    public static final Endpoint<ValidateQueryRequest, ValidateQueryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ValidateQueryRequest, ValidateQueryResponse>(request -> "POST", request -> {
        boolean _index = true;
        int _type = 2;
        int propsSet = 0;
        if (request.index() != null) {
            propsSet |= 1;
        }
        if (request.type() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_validate");
            buf.append("/query");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_validate");
            buf.append("/query");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_validate");
            buf.append("/query");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.allShards != null) {
            params.put("all_shards", String.valueOf(request.allShards));
        }
        if (request.analyzer != null) {
            params.put("analyzer", request.analyzer);
        }
        if (request.analyzeWildcard != null) {
            params.put("analyze_wildcard", String.valueOf(request.analyzeWildcard));
        }
        if (request.defaultOperator != null) {
            params.put("default_operator", request.defaultOperator.toString());
        }
        if (request.df != null) {
            params.put("df", request.df);
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.explain != null) {
            params.put("explain", String.valueOf(request.explain));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.lenient != null) {
            params.put("lenient", String.valueOf(request.lenient));
        }
        if (request.rewrite != null) {
            params.put("rewrite", String.valueOf(request.rewrite));
        }
        if (request.q != null) {
            params.put("q", request.q);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ValidateQueryResponse._DESERIALIZER);

    public ValidateQueryRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.type = ModelTypeHelper.unmodifiable(builder.type);
        this.allowNoIndices = builder.allowNoIndices;
        this.allShards = builder.allShards;
        this.analyzer = builder.analyzer;
        this.analyzeWildcard = builder.analyzeWildcard;
        this.defaultOperator = builder.defaultOperator;
        this.df = builder.df;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.explain = builder.explain;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.lenient = builder.lenient;
        this.rewrite = builder.rewrite;
        this.q = builder.q;
        this.query = builder.query;
    }

    public ValidateQueryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<String> type() {
        return this.type;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public Boolean allShards() {
        return this.allShards;
    }

    @Nullable
    public String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Boolean analyzeWildcard() {
        return this.analyzeWildcard;
    }

    @Nullable
    public DefaultOperator defaultOperator() {
        return this.defaultOperator;
    }

    @Nullable
    public String df() {
        return this.df;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean lenient() {
        return this.lenient;
    }

    @Nullable
    public Boolean rewrite() {
        return this.rewrite;
    }

    @Nullable
    public String q() {
        return this.q;
    }

    @Nullable
    public Query query() {
        return this.query;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
    }

    protected static void setupValidateQueryRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::query, Query._DESERIALIZER, "query", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ValidateQueryRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private List<String> type;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean allShards;
        @Nullable
        private String analyzer;
        @Nullable
        private Boolean analyzeWildcard;
        @Nullable
        private DefaultOperator defaultOperator;
        @Nullable
        private String df;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean explain;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean lenient;
        @Nullable
        private Boolean rewrite;
        @Nullable
        private String q;
        @Nullable
        private Query query;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder type(@Nullable List<String> value) {
            this.type = value;
            return this;
        }

        public Builder type(String ... value) {
            this.type = Arrays.asList(value);
            return this;
        }

        public Builder addType(String value) {
            if (this.type == null) {
                this.type = new ArrayList<String>();
            }
            this.type.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder allShards(@Nullable Boolean value) {
            this.allShards = value;
            return this;
        }

        public Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public Builder analyzeWildcard(@Nullable Boolean value) {
            this.analyzeWildcard = value;
            return this;
        }

        public Builder defaultOperator(@Nullable DefaultOperator value) {
            this.defaultOperator = value;
            return this;
        }

        public Builder df(@Nullable String value) {
            this.df = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder lenient(@Nullable Boolean value) {
            this.lenient = value;
            return this;
        }

        public Builder rewrite(@Nullable Boolean value) {
            this.rewrite = value;
            return this;
        }

        public Builder q(@Nullable String value) {
            this.q = value;
            return this;
        }

        public Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        @Override
        public ValidateQueryRequest build() {
            return new ValidateQueryRequest(this);
        }
    }
}

