/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.SimulateTemplateResponse;
import co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplate;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class SimulateTemplateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String name;
    @Nullable
    private final Boolean create;
    @Nullable
    private final String masterTimeout;
    private final IndexTemplate template;
    public static final JsonpDeserializer<SimulateTemplateRequest> _DESERIALIZER = SimulateTemplateRequest.createSimulateTemplateRequestDeserializer();
    public static final Endpoint<SimulateTemplateRequest, SimulateTemplateResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<SimulateTemplateRequest, SimulateTemplateResponse>(request -> "POST", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/_simulate");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_index_template");
            buf.append("/_simulate");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.create != null) {
            params.put("create", String.valueOf(request.create));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SimulateTemplateResponse._DESERIALIZER);

    public SimulateTemplateRequest(Builder builder) {
        this.name = builder.name;
        this.create = builder.create;
        this.masterTimeout = builder.masterTimeout;
        this.template = Objects.requireNonNull(builder.template, "_value_body");
    }

    public SimulateTemplateRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public Boolean create() {
        return this.create;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public IndexTemplate template() {
        return this.template;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.template.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<SimulateTemplateRequest> createSimulateTemplateRequestDeserializer() {
        JsonpDeserializer<IndexTemplate> valueDeserializer = IndexTemplate._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().template((IndexTemplate)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<SimulateTemplateRequest> {
        @Nullable
        private String name;
        @Nullable
        private Boolean create;
        @Nullable
        private String masterTimeout;
        private IndexTemplate template;

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder create(@Nullable Boolean value) {
            this.create = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder template(IndexTemplate value) {
            this.template = value;
            return this;
        }

        public Builder template(Function<IndexTemplate.Builder, ObjectBuilder<IndexTemplate>> fn) {
            return this.template(fn.apply(new IndexTemplate.Builder()).build());
        }

        @Override
        public SimulateTemplateRequest build() {
            return new SimulateTemplateRequest(this);
        }
    }
}

