/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.reload_search_analyzers.ReloadDetails;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ReloadSearchAnalyzersResponse
implements JsonpSerializable {
    private final List<ReloadDetails> reloadDetails;
    private final ShardStatistics shards;
    public static final JsonpDeserializer<ReloadSearchAnalyzersResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReloadSearchAnalyzersResponse::setupReloadSearchAnalyzersResponseDeserializer, Builder::build);

    public ReloadSearchAnalyzersResponse(Builder builder) {
        this.reloadDetails = ModelTypeHelper.unmodifiableNonNull(builder.reloadDetails, "reload_details");
        this.shards = Objects.requireNonNull(builder.shards, "_shards");
    }

    public ReloadSearchAnalyzersResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<ReloadDetails> reloadDetails() {
        return this.reloadDetails;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("reload_details");
        generator.writeStartArray();
        for (ReloadDetails item0 : this.reloadDetails) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    protected static void setupReloadSearchAnalyzersResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::reloadDetails, JsonpDeserializer.arrayDeserializer(ReloadDetails._DESERIALIZER), "reload_details", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ReloadSearchAnalyzersResponse> {
        private List<ReloadDetails> reloadDetails;
        private ShardStatistics shards;

        public Builder reloadDetails(List<ReloadDetails> value) {
            this.reloadDetails = value;
            return this;
        }

        public Builder reloadDetails(ReloadDetails ... value) {
            this.reloadDetails = Arrays.asList(value);
            return this;
        }

        public Builder addReloadDetails(ReloadDetails value) {
            if (this.reloadDetails == null) {
                this.reloadDetails = new ArrayList<ReloadDetails>();
            }
            this.reloadDetails.add(value);
            return this;
        }

        public Builder reloadDetails(Function<ReloadDetails.Builder, ObjectBuilder<ReloadDetails>> fn) {
            return this.reloadDetails(fn.apply(new ReloadDetails.Builder()).build());
        }

        public Builder addReloadDetails(Function<ReloadDetails.Builder, ObjectBuilder<ReloadDetails>> fn) {
            return this.addReloadDetails(fn.apply(new ReloadDetails.Builder()).build());
        }

        public Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        public ReloadSearchAnalyzersResponse build() {
            return new ReloadSearchAnalyzersResponse(this);
        }
    }
}

