/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.PutSettingsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutSettingsRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final List<String> index;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean flatSettings;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final Boolean preserveExisting;
    @Nullable
    private final String timeout;
    private final IndexSettings settings;
    public static final JsonpDeserializer<PutSettingsRequest> _DESERIALIZER = PutSettingsRequest.createPutSettingsRequestDeserializer();
    public static final Endpoint<PutSettingsRequest, PutSettingsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutSettingsRequest, PutSettingsResponse>(request -> "PUT", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_settings");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_settings");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.flatSettings != null) {
            params.put("flat_settings", String.valueOf(request.flatSettings));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.preserveExisting != null) {
            params.put("preserve_existing", String.valueOf(request.preserveExisting));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutSettingsResponse._DESERIALIZER);

    public PutSettingsRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.flatSettings = builder.flatSettings;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.masterTimeout = builder.masterTimeout;
        this.preserveExisting = builder.preserveExisting;
        this.timeout = builder.timeout;
        this.settings = Objects.requireNonNull(builder.settings, "_value_body");
    }

    public PutSettingsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean flatSettings() {
        return this.flatSettings;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public Boolean preserveExisting() {
        return this.preserveExisting;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public IndexSettings settings() {
        return this.settings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.settings.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<PutSettingsRequest> createPutSettingsRequestDeserializer() {
        JsonpDeserializer<IndexSettings> valueDeserializer = IndexSettings._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().settings((IndexSettings)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<PutSettingsRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean flatSettings;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private String masterTimeout;
        @Nullable
        private Boolean preserveExisting;
        @Nullable
        private String timeout;
        private IndexSettings settings;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder flatSettings(@Nullable Boolean value) {
            this.flatSettings = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder preserveExisting(@Nullable Boolean value) {
            this.preserveExisting = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder settings(IndexSettings value) {
            this.settings = value;
            return this;
        }

        public Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        @Override
        public PutSettingsRequest build() {
            return new PutSettingsRequest(this);
        }
    }
}

