/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.analysis.Analyzer;
import co.elastic.clients.elasticsearch._types.analysis.CharFilter;
import co.elastic.clients.elasticsearch._types.analysis.Normalizer;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilter;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexSettingsAnalysis
implements JsonpSerializable {
    @Nullable
    private final Map<String, Analyzer> analyzer;
    @Nullable
    private final Map<String, CharFilter> charFilter;
    @Nullable
    private final Map<String, TokenFilter> filter;
    @Nullable
    private final Map<String, Normalizer> normalizer;
    public static final JsonpDeserializer<IndexSettingsAnalysis> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsAnalysis::setupIndexSettingsAnalysisDeserializer, Builder::build);

    public IndexSettingsAnalysis(Builder builder) {
        this.analyzer = ModelTypeHelper.unmodifiable(builder.analyzer);
        this.charFilter = ModelTypeHelper.unmodifiable(builder.charFilter);
        this.filter = ModelTypeHelper.unmodifiable(builder.filter);
        this.normalizer = ModelTypeHelper.unmodifiable(builder.normalizer);
    }

    public IndexSettingsAnalysis(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public Map<String, Analyzer> analyzer() {
        return this.analyzer;
    }

    @Nullable
    public Map<String, CharFilter> charFilter() {
        return this.charFilter;
    }

    @Nullable
    public Map<String, TokenFilter> filter() {
        return this.filter;
    }

    @Nullable
    public Map<String, Normalizer> normalizer() {
        return this.normalizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.analyzer.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Analyzer)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.charFilter != null) {
            generator.writeKey("char_filter");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.charFilter.entrySet()) {
                generator.writeKey(entry.getKey());
                ((CharFilter)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.filter.entrySet()) {
                generator.writeKey(entry.getKey());
                ((TokenFilter)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.normalizer.entrySet()) {
                generator.writeKey(entry.getKey());
                ((Normalizer)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndexSettingsAnalysisDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringMapDeserializer(Analyzer._DESERIALIZER), "analyzer", new String[0]);
        op.add(Builder::charFilter, JsonpDeserializer.stringMapDeserializer(CharFilter._DESERIALIZER), "char_filter", new String[0]);
        op.add(Builder::filter, JsonpDeserializer.stringMapDeserializer(TokenFilter._DESERIALIZER), "filter", new String[0]);
        op.add(Builder::normalizer, JsonpDeserializer.stringMapDeserializer(Normalizer._DESERIALIZER), "normalizer", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexSettingsAnalysis> {
        @Nullable
        private Map<String, Analyzer> analyzer;
        @Nullable
        private Map<String, CharFilter> charFilter;
        @Nullable
        private Map<String, TokenFilter> filter;
        @Nullable
        private Map<String, Normalizer> normalizer;

        public Builder analyzer(@Nullable Map<String, Analyzer> value) {
            this.analyzer = value;
            return this;
        }

        public Builder putAnalyzer(String key, Analyzer value) {
            if (this.analyzer == null) {
                this.analyzer = new HashMap<String, Analyzer>();
            }
            this.analyzer.put(key, value);
            return this;
        }

        public Builder analyzer(String key, Function<Analyzer.Builder, ObjectBuilder<Analyzer>> fn) {
            return this.analyzer(Collections.singletonMap(key, fn.apply(new Analyzer.Builder()).build()));
        }

        public Builder putAnalyzer(String key, Function<Analyzer.Builder, ObjectBuilder<Analyzer>> fn) {
            return this.putAnalyzer(key, fn.apply(new Analyzer.Builder()).build());
        }

        public Builder charFilter(@Nullable Map<String, CharFilter> value) {
            this.charFilter = value;
            return this;
        }

        public Builder putCharFilter(String key, CharFilter value) {
            if (this.charFilter == null) {
                this.charFilter = new HashMap<String, CharFilter>();
            }
            this.charFilter.put(key, value);
            return this;
        }

        public Builder charFilter(String key, Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.charFilter(Collections.singletonMap(key, fn.apply(new CharFilter.Builder()).build()));
        }

        public Builder putCharFilter(String key, Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.putCharFilter(key, fn.apply(new CharFilter.Builder()).build());
        }

        public Builder filter(@Nullable Map<String, TokenFilter> value) {
            this.filter = value;
            return this;
        }

        public Builder putFilter(String key, TokenFilter value) {
            if (this.filter == null) {
                this.filter = new HashMap<String, TokenFilter>();
            }
            this.filter.put(key, value);
            return this;
        }

        public Builder filter(String key, Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.filter(Collections.singletonMap(key, fn.apply(new TokenFilter.Builder()).build()));
        }

        public Builder putFilter(String key, Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.putFilter(key, fn.apply(new TokenFilter.Builder()).build());
        }

        public Builder normalizer(@Nullable Map<String, Normalizer> value) {
            this.normalizer = value;
            return this;
        }

        public Builder putNormalizer(String key, Normalizer value) {
            if (this.normalizer == null) {
                this.normalizer = new HashMap<String, Normalizer>();
            }
            this.normalizer.put(key, value);
            return this;
        }

        public Builder normalizer(String key, Function<Normalizer.Builder, ObjectBuilder<Normalizer>> fn) {
            return this.normalizer(Collections.singletonMap(key, fn.apply(new Normalizer.Builder()).build()));
        }

        public Builder putNormalizer(String key, Function<Normalizer.Builder, ObjectBuilder<Normalizer>> fn) {
            return this.putNormalizer(key, fn.apply(new Normalizer.Builder()).build());
        }

        @Override
        public IndexSettingsAnalysis build() {
            return new IndexSettingsAnalysis(this);
        }
    }
}

