/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.IndexRoutingAllocation;
import co.elastic.clients.elasticsearch.indices.IndexRoutingRebalance;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class IndexRouting
implements JsonpSerializable {
    @Nullable
    private final IndexRoutingAllocation allocation;
    @Nullable
    private final IndexRoutingRebalance rebalance;
    public static final JsonpDeserializer<IndexRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexRouting::setupIndexRoutingDeserializer, Builder::build);

    public IndexRouting(Builder builder) {
        this.allocation = builder.allocation;
        this.rebalance = builder.rebalance;
    }

    public IndexRouting(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public IndexRoutingAllocation allocation() {
        return this.allocation;
    }

    @Nullable
    public IndexRoutingRebalance rebalance() {
        return this.rebalance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allocation != null) {
            generator.writeKey("allocation");
            this.allocation.serialize(generator, mapper);
        }
        if (this.rebalance != null) {
            generator.writeKey("rebalance");
            this.rebalance.serialize(generator, mapper);
        }
    }

    protected static void setupIndexRoutingDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::allocation, IndexRoutingAllocation._DESERIALIZER, "allocation", new String[0]);
        op.add(Builder::rebalance, IndexRoutingRebalance._DESERIALIZER, "rebalance", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndexRouting> {
        @Nullable
        private IndexRoutingAllocation allocation;
        @Nullable
        private IndexRoutingRebalance rebalance;

        public Builder allocation(@Nullable IndexRoutingAllocation value) {
            this.allocation = value;
            return this;
        }

        public Builder allocation(Function<IndexRoutingAllocation.Builder, ObjectBuilder<IndexRoutingAllocation>> fn) {
            return this.allocation(fn.apply(new IndexRoutingAllocation.Builder()).build());
        }

        public Builder rebalance(@Nullable IndexRoutingRebalance value) {
            this.rebalance = value;
            return this;
        }

        public Builder rebalance(Function<IndexRoutingRebalance.Builder, ObjectBuilder<IndexRoutingRebalance>> fn) {
            return this.rebalance(fn.apply(new IndexRoutingRebalance.Builder()).build());
        }

        @Override
        public IndexRouting build() {
            return new IndexRouting(this);
        }
    }
}

