/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.DataStreamsStatsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DataStreamsStatsRequest
extends RequestBase {
    @Nullable
    private final String name;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    public static final Endpoint<DataStreamsStatsRequest, DataStreamsStatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DataStreamsStatsRequest, DataStreamsStatsResponse>(request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (request.name() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DataStreamsStatsResponse._DESERIALIZER);

    public DataStreamsStatsRequest(Builder builder) {
        this.name = builder.name;
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
    }

    public DataStreamsStatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    public static class Builder
    implements ObjectBuilder<DataStreamsStatsRequest> {
        @Nullable
        private String name;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        @Override
        public DataStreamsStatsRequest build() {
            return new DataStreamsStatsRequest(this);
        }
    }
}

