/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponseBase;
import co.elastic.clients.elasticsearch.indices.add_block.IndicesBlockStatus;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AddBlockResponse
extends AcknowledgedResponseBase {
    private final boolean shardsAcknowledged;
    private final List<IndicesBlockStatus> indices;
    public static final JsonpDeserializer<AddBlockResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AddBlockResponse::setupAddBlockResponseDeserializer, Builder::build);

    public AddBlockResponse(Builder builder) {
        super(builder);
        this.shardsAcknowledged = Objects.requireNonNull(builder.shardsAcknowledged, "shards_acknowledged");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
    }

    public AddBlockResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    public List<IndicesBlockStatus> indices() {
        return this.indices;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
        generator.writeKey("indices");
        generator.writeStartArray();
        for (IndicesBlockStatus item0 : this.indices) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupAddBlockResponseDeserializer(DelegatingDeserializer<Builder> op) {
        AcknowledgedResponseBase.setupAcknowledgedResponseBaseDeserializer(op);
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(IndicesBlockStatus._DESERIALIZER), "indices", new String[0]);
    }

    public static class Builder
    extends AcknowledgedResponseBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AddBlockResponse> {
        private Boolean shardsAcknowledged;
        private List<IndicesBlockStatus> indices;

        public Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        public Builder indices(List<IndicesBlockStatus> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(IndicesBlockStatus ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(IndicesBlockStatus value) {
            if (this.indices == null) {
                this.indices = new ArrayList<IndicesBlockStatus>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder indices(Function<IndicesBlockStatus.Builder, ObjectBuilder<IndicesBlockStatus>> fn) {
            return this.indices(fn.apply(new IndicesBlockStatus.Builder()).build());
        }

        public Builder addIndices(Function<IndicesBlockStatus.Builder, ObjectBuilder<IndicesBlockStatus>> fn) {
            return this.addIndices(fn.apply(new IndicesBlockStatus.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AddBlockResponse build() {
            return new AddBlockResponse(this);
        }
    }
}

