/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.move_to_step;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class StepKey
implements JsonpSerializable {
    private final String action;
    private final String name;
    private final String phase;
    public static final JsonpDeserializer<StepKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StepKey::setupStepKeyDeserializer, Builder::build);

    public StepKey(Builder builder) {
        this.action = Objects.requireNonNull(builder.action, "action");
        this.name = Objects.requireNonNull(builder.name, "name");
        this.phase = Objects.requireNonNull(builder.phase, "phase");
    }

    public StepKey(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String action() {
        return this.action;
    }

    public String name() {
        return this.name;
    }

    public String phase() {
        return this.phase;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("action");
        generator.write(this.action);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("phase");
        generator.write(this.phase);
    }

    protected static void setupStepKeyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::action, JsonpDeserializer.stringDeserializer(), "action", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::phase, JsonpDeserializer.stringDeserializer(), "phase", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<StepKey> {
        private String action;
        private String name;
        private String phase;

        public Builder action(String value) {
            this.action = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder phase(String value) {
            this.phase = value;
            return this;
        }

        @Override
        public StepKey build() {
            return new StepKey(this);
        }
    }
}

