/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ilm.RetryResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

public final class RetryRequest
extends RequestBase {
    private final String index;
    public static final Endpoint<RetryRequest, RetryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<RetryRequest, RetryResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ilm");
            buf.append("/retry");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, RetryResponse._DESERIALIZER);

    public RetryRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
    }

    public RetryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    public static class Builder
    implements ObjectBuilder<RetryRequest> {
        private String index;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        @Override
        public RetryRequest build() {
            return new RetryRequest(this);
        }
    }
}

