/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Phase
implements JsonpSerializable {
    private final JsonValue actions;
    @Nullable
    private final String minAge;
    public static final JsonpDeserializer<Phase> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Phase::setupPhaseDeserializer, Builder::build);

    public Phase(Builder builder) {
        this.actions = Objects.requireNonNull(builder.actions, "actions");
        this.minAge = builder.minAge;
    }

    public Phase(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public JsonValue actions() {
        return this.actions;
    }

    @Nullable
    public String minAge() {
        return this.minAge;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actions");
        generator.write(this.actions);
        if (this.minAge != null) {
            generator.writeKey("min_age");
            generator.write(this.minAge);
        }
    }

    protected static void setupPhaseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.jsonValueDeserializer(), "actions", new String[0]);
        op.add(Builder::minAge, JsonpDeserializer.stringDeserializer(), "min_age", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Phase> {
        private JsonValue actions;
        @Nullable
        private String minAge;

        public Builder actions(JsonValue value) {
            this.actions = value;
            return this;
        }

        public Builder minAge(@Nullable String value) {
            this.minAge = value;
            return this;
        }

        @Override
        public Phase build() {
            return new Phase(this);
        }
    }
}

