/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ilm.MoveToStepResponse;
import co.elastic.clients.elasticsearch.ilm.move_to_step.StepKey;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MoveToStepRequest
extends RequestBase
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final StepKey currentStep;
    @Nullable
    private final StepKey nextStep;
    public static final JsonpDeserializer<MoveToStepRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MoveToStepRequest::setupMoveToStepRequestDeserializer, Builder::build);
    public static final Endpoint<MoveToStepRequest, MoveToStepResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<MoveToStepRequest, MoveToStepResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ilm");
            buf.append("/move");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, MoveToStepResponse._DESERIALIZER);

    public MoveToStepRequest(Builder builder) {
        this.index = Objects.requireNonNull(builder.index, "index");
        this.currentStep = builder.currentStep;
        this.nextStep = builder.nextStep;
    }

    public MoveToStepRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    @Nullable
    public StepKey currentStep() {
        return this.currentStep;
    }

    @Nullable
    public StepKey nextStep() {
        return this.nextStep;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentStep != null) {
            generator.writeKey("current_step");
            this.currentStep.serialize(generator, mapper);
        }
        if (this.nextStep != null) {
            generator.writeKey("next_step");
            this.nextStep.serialize(generator, mapper);
        }
    }

    protected static void setupMoveToStepRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::currentStep, StepKey._DESERIALIZER, "current_step", new String[0]);
        op.add(Builder::nextStep, StepKey._DESERIALIZER, "next_step", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MoveToStepRequest> {
        private String index;
        @Nullable
        private StepKey currentStep;
        @Nullable
        private StepKey nextStep;

        public Builder index(String value) {
            this.index = value;
            return this;
        }

        public Builder currentStep(@Nullable StepKey value) {
            this.currentStep = value;
            return this;
        }

        public Builder currentStep(Function<StepKey.Builder, ObjectBuilder<StepKey>> fn) {
            return this.currentStep(fn.apply(new StepKey.Builder()).build());
        }

        public Builder nextStep(@Nullable StepKey value) {
            this.nextStep = value;
            return this;
        }

        public Builder nextStep(Function<StepKey.Builder, ObjectBuilder<StepKey>> fn) {
            return this.nextStep(fn.apply(new StepKey.Builder()).build());
        }

        @Override
        public MoveToStepRequest build() {
            return new MoveToStepRequest(this);
        }
    }
}

