/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class VertexInclude
implements JsonpSerializable {
    private final double boost;
    private final String term;
    public static final JsonpDeserializer<VertexInclude> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, VertexInclude::setupVertexIncludeDeserializer, Builder::build);

    public VertexInclude(Builder builder) {
        this.boost = Objects.requireNonNull(builder.boost, "boost");
        this.term = Objects.requireNonNull(builder.term, "term");
    }

    public VertexInclude(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public double boost() {
        return this.boost;
    }

    public String term() {
        return this.term;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("boost");
        generator.write(this.boost);
        generator.writeKey("term");
        generator.write(this.term);
    }

    protected static void setupVertexIncludeDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost", new String[0]);
        op.add(Builder::term, JsonpDeserializer.stringDeserializer(), "term", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<VertexInclude> {
        private Double boost;
        private String term;

        public Builder boost(double value) {
            this.boost = value;
            return this;
        }

        public Builder term(String value) {
            this.term = value;
            return this;
        }

        @Override
        public VertexInclude build() {
            return new VertexInclude(this);
        }
    }
}

