/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Connection
implements JsonpSerializable {
    private final long docCount;
    private final long source;
    private final long target;
    private final double weight;
    public static final JsonpDeserializer<Connection> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Connection::setupConnectionDeserializer, Builder::build);

    public Connection(Builder builder) {
        this.docCount = Objects.requireNonNull(builder.docCount, "doc_count");
        this.source = Objects.requireNonNull(builder.source, "source");
        this.target = Objects.requireNonNull(builder.target, "target");
        this.weight = Objects.requireNonNull(builder.weight, "weight");
    }

    public Connection(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long docCount() {
        return this.docCount;
    }

    public long source() {
        return this.source;
    }

    public long target() {
        return this.target;
    }

    public double weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        generator.writeKey("source");
        generator.write(this.source);
        generator.writeKey("target");
        generator.write(this.target);
        generator.writeKey("weight");
        generator.write(this.weight);
    }

    protected static void setupConnectionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::docCount, JsonpDeserializer.longDeserializer(), "doc_count", new String[0]);
        op.add(Builder::source, JsonpDeserializer.longDeserializer(), "source", new String[0]);
        op.add(Builder::target, JsonpDeserializer.longDeserializer(), "target", new String[0]);
        op.add(Builder::weight, JsonpDeserializer.doubleDeserializer(), "weight", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Connection> {
        private Long docCount;
        private Long source;
        private Long target;
        private Double weight;

        public Builder docCount(long value) {
            this.docCount = value;
            return this;
        }

        public Builder source(long value) {
            this.source = value;
            return this;
        }

        public Builder target(long value) {
            this.target = value;
            return this;
        }

        public Builder weight(double value) {
            this.weight = value;
            return this;
        }

        @Override
        public Connection build() {
            return new Connection(this);
        }
    }
}

