/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.eql;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HitsEvent<TEvent>
implements JsonpSerializable {
    private final String index;
    private final String id;
    private final TEvent source;
    @Nullable
    private final Map<String, List<JsonData>> fields;
    @Nullable
    private final JsonpSerializer<TEvent> tEventSerializer;

    public HitsEvent(Builder<TEvent> builder) {
        this.index = Objects.requireNonNull(((Builder)builder).index, "_index");
        this.id = Objects.requireNonNull(((Builder)builder).id, "_id");
        this.source = Objects.requireNonNull(((Builder)builder).source, "_source");
        this.fields = ModelTypeHelper.unmodifiable(((Builder)builder).fields);
        this.tEventSerializer = ((Builder)builder).tEventSerializer;
    }

    public HitsEvent(Function<Builder<TEvent>, Builder<TEvent>> fn) {
        this(fn.apply(new Builder()));
    }

    public String index() {
        return this.index;
    }

    public String id() {
        return this.id;
    }

    public TEvent source() {
        return this.source;
    }

    @Nullable
    public Map<String, List<JsonData>> fields() {
        return this.fields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("_source");
        JsonpUtils.serialize(this.source, generator, this.tEventSerializer, mapper);
        if (this.fields != null) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, List<JsonData>> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                for (JsonData item1 : item0.getValue()) {
                    item1.serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    public static <TEvent> JsonpDeserializer<HitsEvent<TEvent>> createHitsEventDeserializer(JsonpDeserializer<TEvent> tEventDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> HitsEvent.setupHitsEventDeserializer(op, tEventDeserializer));
    }

    protected static <TEvent> void setupHitsEventDeserializer(DelegatingDeserializer<Builder<TEvent>> op, JsonpDeserializer<TEvent> tEventDeserializer) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index", new String[0]);
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id", new String[0]);
        op.add(Builder::source, tEventDeserializer, "_source", new String[0]);
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER)), "fields", new String[0]);
    }

    public static class Builder<TEvent>
    implements ObjectBuilder<HitsEvent<TEvent>> {
        private String index;
        private String id;
        private TEvent source;
        @Nullable
        private Map<String, List<JsonData>> fields;
        @Nullable
        private JsonpSerializer<TEvent> tEventSerializer;

        public Builder<TEvent> index(String value) {
            this.index = value;
            return this;
        }

        public Builder<TEvent> id(String value) {
            this.id = value;
            return this;
        }

        public Builder<TEvent> source(TEvent value) {
            this.source = value;
            return this;
        }

        public Builder<TEvent> fields(@Nullable Map<String, List<JsonData>> value) {
            this.fields = value;
            return this;
        }

        public Builder<TEvent> putFields(String key, List<JsonData> value) {
            if (this.fields == null) {
                this.fields = new HashMap<String, List<JsonData>>();
            }
            this.fields.put(key, value);
            return this;
        }

        public Builder<TEvent> tEventSerializer(@Nullable JsonpSerializer<TEvent> value) {
            this.tEventSerializer = value;
            return this;
        }

        @Override
        public HitsEvent<TEvent> build() {
            return new HitsEvent(this);
        }
    }
}

