/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class CacheStats
implements JsonpSerializable {
    private final String nodeId;
    private final int count;
    private final int hits;
    private final int misses;
    private final int evictions;
    public static final JsonpDeserializer<CacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CacheStats::setupCacheStatsDeserializer, Builder::build);

    public CacheStats(Builder builder) {
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
        this.count = Objects.requireNonNull(builder.count, "count");
        this.hits = Objects.requireNonNull(builder.hits, "hits");
        this.misses = Objects.requireNonNull(builder.misses, "misses");
        this.evictions = Objects.requireNonNull(builder.evictions, "evictions");
    }

    public CacheStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String nodeId() {
        return this.nodeId;
    }

    public int count() {
        return this.count;
    }

    public int hits() {
        return this.hits;
    }

    public int misses() {
        return this.misses;
    }

    public int evictions() {
        return this.evictions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("hits");
        generator.write(this.hits);
        generator.writeKey("misses");
        generator.write(this.misses);
        generator.writeKey("evictions");
        generator.write(this.evictions);
    }

    protected static void setupCacheStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id", new String[0]);
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::hits, JsonpDeserializer.integerDeserializer(), "hits", new String[0]);
        op.add(Builder::misses, JsonpDeserializer.integerDeserializer(), "misses", new String[0]);
        op.add(Builder::evictions, JsonpDeserializer.integerDeserializer(), "evictions", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CacheStats> {
        private String nodeId;
        private Integer count;
        private Integer hits;
        private Integer misses;
        private Integer evictions;

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder hits(int value) {
            this.hits = value;
            return this;
        }

        public Builder misses(int value) {
            this.misses = value;
            return this;
        }

        public Builder evictions(int value) {
            this.evictions = value;
            return this;
        }

        @Override
        public CacheStats build() {
            return new CacheStats(this);
        }
    }
}

