/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Policy
implements JsonpSerializable {
    private final List<String> enrichFields;
    private final List<String> indices;
    private final String matchField;
    @Nullable
    private final String query;
    @Nullable
    private final String name;
    public static final JsonpDeserializer<Policy> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Policy::setupPolicyDeserializer, Builder::build);

    public Policy(Builder builder) {
        this.enrichFields = ModelTypeHelper.unmodifiableNonNull(builder.enrichFields, "enrich_fields");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.matchField = Objects.requireNonNull(builder.matchField, "match_field");
        this.query = builder.query;
        this.name = builder.name;
    }

    public Policy(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> enrichFields() {
        return this.enrichFields;
    }

    public List<String> indices() {
        return this.indices;
    }

    public String matchField() {
        return this.matchField;
    }

    @Nullable
    public String query() {
        return this.query;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enrich_fields");
        generator.writeStartArray();
        for (String item0 : this.enrichFields) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String item0 : this.indices) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("match_field");
        generator.write(this.matchField);
        if (this.query != null) {
            generator.writeKey("query");
            generator.write(this.query);
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
    }

    protected static void setupPolicyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::enrichFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "enrich_fields", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::matchField, JsonpDeserializer.stringDeserializer(), "match_field", new String[0]);
        op.add(Builder::query, JsonpDeserializer.stringDeserializer(), "query", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Policy> {
        private List<String> enrichFields;
        private List<String> indices;
        private String matchField;
        @Nullable
        private String query;
        @Nullable
        private String name;

        public Builder enrichFields(List<String> value) {
            this.enrichFields = value;
            return this;
        }

        public Builder enrichFields(String ... value) {
            this.enrichFields = Arrays.asList(value);
            return this;
        }

        public Builder addEnrichFields(String value) {
            if (this.enrichFields == null) {
                this.enrichFields = new ArrayList<String>();
            }
            this.enrichFields.add(value);
            return this;
        }

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder matchField(String value) {
            this.matchField = value;
            return this;
        }

        public Builder query(@Nullable String value) {
            this.query = value;
            return this;
        }

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        @Override
        public Policy build() {
            return new Policy(this);
        }
    }
}

