/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class IndicesVersions
implements JsonpSerializable {
    private final int indexCount;
    private final int primaryShardCount;
    private final long totalPrimaryBytes;
    private final String version;
    public static final JsonpDeserializer<IndicesVersions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicesVersions::setupIndicesVersionsDeserializer, Builder::build);

    public IndicesVersions(Builder builder) {
        this.indexCount = Objects.requireNonNull(builder.indexCount, "index_count");
        this.primaryShardCount = Objects.requireNonNull(builder.primaryShardCount, "primary_shard_count");
        this.totalPrimaryBytes = Objects.requireNonNull(builder.totalPrimaryBytes, "total_primary_bytes");
        this.version = Objects.requireNonNull(builder.version, "version");
    }

    public IndicesVersions(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int indexCount() {
        return this.indexCount;
    }

    public int primaryShardCount() {
        return this.primaryShardCount;
    }

    public long totalPrimaryBytes() {
        return this.totalPrimaryBytes;
    }

    public String version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        generator.writeKey("primary_shard_count");
        generator.write(this.primaryShardCount);
        generator.writeKey("total_primary_bytes");
        generator.write(this.totalPrimaryBytes);
        generator.writeKey("version");
        generator.write(this.version);
    }

    protected static void setupIndicesVersionsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::indexCount, JsonpDeserializer.integerDeserializer(), "index_count", new String[0]);
        op.add(Builder::primaryShardCount, JsonpDeserializer.integerDeserializer(), "primary_shard_count", new String[0]);
        op.add(Builder::totalPrimaryBytes, JsonpDeserializer.longDeserializer(), "total_primary_bytes", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<IndicesVersions> {
        private Integer indexCount;
        private Integer primaryShardCount;
        private Long totalPrimaryBytes;
        private String version;

        public Builder indexCount(int value) {
            this.indexCount = value;
            return this;
        }

        public Builder primaryShardCount(int value) {
            this.primaryShardCount = value;
            return this;
        }

        public Builder totalPrimaryBytes(long value) {
            this.totalPrimaryBytes = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        @Override
        public IndicesVersions build() {
            return new IndicesVersions(this);
        }
    }
}

