/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterOperatingSystemPrettyName
implements JsonpSerializable {
    private final int count;
    private final String prettyName;
    public static final JsonpDeserializer<ClusterOperatingSystemPrettyName> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterOperatingSystemPrettyName::setupClusterOperatingSystemPrettyNameDeserializer, Builder::build);

    public ClusterOperatingSystemPrettyName(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.prettyName = Objects.requireNonNull(builder.prettyName, "pretty_name");
    }

    public ClusterOperatingSystemPrettyName(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int count() {
        return this.count;
    }

    public String prettyName() {
        return this.prettyName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("pretty_name");
        generator.write(this.prettyName);
    }

    protected static void setupClusterOperatingSystemPrettyNameDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::prettyName, JsonpDeserializer.stringDeserializer(), "pretty_name", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterOperatingSystemPrettyName> {
        private Integer count;
        private String prettyName;

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder prettyName(String value) {
            this.prettyName = value;
            return this;
        }

        @Override
        public ClusterOperatingSystemPrettyName build() {
            return new ClusterOperatingSystemPrettyName(this);
        }
    }
}

