/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterJvmVersion
implements JsonpSerializable {
    private final boolean bundledJdk;
    private final int count;
    private final boolean usingBundledJdk;
    private final String version;
    private final String vmName;
    private final String vmVendor;
    private final String vmVersion;
    public static final JsonpDeserializer<ClusterJvmVersion> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvmVersion::setupClusterJvmVersionDeserializer, Builder::build);

    public ClusterJvmVersion(Builder builder) {
        this.bundledJdk = Objects.requireNonNull(builder.bundledJdk, "bundled_jdk");
        this.count = Objects.requireNonNull(builder.count, "count");
        this.usingBundledJdk = Objects.requireNonNull(builder.usingBundledJdk, "using_bundled_jdk");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.vmName = Objects.requireNonNull(builder.vmName, "vm_name");
        this.vmVendor = Objects.requireNonNull(builder.vmVendor, "vm_vendor");
        this.vmVersion = Objects.requireNonNull(builder.vmVersion, "vm_version");
    }

    public ClusterJvmVersion(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public boolean bundledJdk() {
        return this.bundledJdk;
    }

    public int count() {
        return this.count;
    }

    public boolean usingBundledJdk() {
        return this.usingBundledJdk;
    }

    public String version() {
        return this.version;
    }

    public String vmName() {
        return this.vmName;
    }

    public String vmVendor() {
        return this.vmVendor;
    }

    public String vmVersion() {
        return this.vmVersion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bundled_jdk");
        generator.write(this.bundledJdk);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("using_bundled_jdk");
        generator.write(this.usingBundledJdk);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("vm_name");
        generator.write(this.vmName);
        generator.writeKey("vm_vendor");
        generator.write(this.vmVendor);
        generator.writeKey("vm_version");
        generator.write(this.vmVersion);
    }

    protected static void setupClusterJvmVersionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::bundledJdk, JsonpDeserializer.booleanDeserializer(), "bundled_jdk", new String[0]);
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count", new String[0]);
        op.add(Builder::usingBundledJdk, JsonpDeserializer.booleanDeserializer(), "using_bundled_jdk", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::vmName, JsonpDeserializer.stringDeserializer(), "vm_name", new String[0]);
        op.add(Builder::vmVendor, JsonpDeserializer.stringDeserializer(), "vm_vendor", new String[0]);
        op.add(Builder::vmVersion, JsonpDeserializer.stringDeserializer(), "vm_version", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterJvmVersion> {
        private Boolean bundledJdk;
        private Integer count;
        private Boolean usingBundledJdk;
        private String version;
        private String vmName;
        private String vmVendor;
        private String vmVersion;

        public Builder bundledJdk(boolean value) {
            this.bundledJdk = value;
            return this;
        }

        public Builder count(int value) {
            this.count = value;
            return this;
        }

        public Builder usingBundledJdk(boolean value) {
            this.usingBundledJdk = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder vmName(String value) {
            this.vmName = value;
            return this;
        }

        public Builder vmVendor(String value) {
            this.vmVendor = value;
            return this;
        }

        public Builder vmVersion(String value) {
            this.vmVersion = value;
            return this;
        }

        @Override
        public ClusterJvmVersion build() {
            return new ClusterJvmVersion(this);
        }
    }
}

