/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterJvmMemory
implements JsonpSerializable {
    private final long heapMaxInBytes;
    private final long heapUsedInBytes;
    public static final JsonpDeserializer<ClusterJvmMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterJvmMemory::setupClusterJvmMemoryDeserializer, Builder::build);

    public ClusterJvmMemory(Builder builder) {
        this.heapMaxInBytes = Objects.requireNonNull(builder.heapMaxInBytes, "heap_max_in_bytes");
        this.heapUsedInBytes = Objects.requireNonNull(builder.heapUsedInBytes, "heap_used_in_bytes");
    }

    public ClusterJvmMemory(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long heapMaxInBytes() {
        return this.heapMaxInBytes;
    }

    public long heapUsedInBytes() {
        return this.heapUsedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("heap_max_in_bytes");
        generator.write(this.heapMaxInBytes);
        generator.writeKey("heap_used_in_bytes");
        generator.write(this.heapUsedInBytes);
    }

    protected static void setupClusterJvmMemoryDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::heapMaxInBytes, JsonpDeserializer.longDeserializer(), "heap_max_in_bytes", new String[0]);
        op.add(Builder::heapUsedInBytes, JsonpDeserializer.longDeserializer(), "heap_used_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterJvmMemory> {
        private Long heapMaxInBytes;
        private Long heapUsedInBytes;

        public Builder heapMaxInBytes(long value) {
            this.heapMaxInBytes = value;
            return this;
        }

        public Builder heapUsedInBytes(long value) {
            this.heapUsedInBytes = value;
            return this;
        }

        @Override
        public ClusterJvmMemory build() {
            return new ClusterJvmMemory(this);
        }
    }
}

