/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterFileSystem
implements JsonpSerializable {
    private final long availableInBytes;
    private final long freeInBytes;
    private final long totalInBytes;
    public static final JsonpDeserializer<ClusterFileSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterFileSystem::setupClusterFileSystemDeserializer, Builder::build);

    public ClusterFileSystem(Builder builder) {
        this.availableInBytes = Objects.requireNonNull(builder.availableInBytes, "available_in_bytes");
        this.freeInBytes = Objects.requireNonNull(builder.freeInBytes, "free_in_bytes");
        this.totalInBytes = Objects.requireNonNull(builder.totalInBytes, "total_in_bytes");
    }

    public ClusterFileSystem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long availableInBytes() {
        return this.availableInBytes;
    }

    public long freeInBytes() {
        return this.freeInBytes;
    }

    public long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    protected static void setupClusterFileSystemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes", new String[0]);
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes", new String[0]);
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClusterFileSystem> {
        private Long availableInBytes;
        private Long freeInBytes;
        private Long totalInBytes;

        public Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        public Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        public ClusterFileSystem build() {
            return new ClusterFileSystem(this);
        }
    }
}

