/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.reroute;

import co.elastic.clients.elasticsearch.cluster.reroute.RerouteDecision;
import co.elastic.clients.elasticsearch.cluster.reroute.RerouteParameters;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RerouteExplanation
implements JsonpSerializable {
    private final String command;
    private final List<RerouteDecision> decisions;
    private final RerouteParameters parameters;
    public static final JsonpDeserializer<RerouteExplanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RerouteExplanation::setupRerouteExplanationDeserializer, Builder::build);

    public RerouteExplanation(Builder builder) {
        this.command = Objects.requireNonNull(builder.command, "command");
        this.decisions = ModelTypeHelper.unmodifiableNonNull(builder.decisions, "decisions");
        this.parameters = Objects.requireNonNull(builder.parameters, "parameters");
    }

    public RerouteExplanation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String command() {
        return this.command;
    }

    public List<RerouteDecision> decisions() {
        return this.decisions;
    }

    public RerouteParameters parameters() {
        return this.parameters;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("command");
        generator.write(this.command);
        generator.writeKey("decisions");
        generator.writeStartArray();
        for (RerouteDecision item0 : this.decisions) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("parameters");
        this.parameters.serialize(generator, mapper);
    }

    protected static void setupRerouteExplanationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::command, JsonpDeserializer.stringDeserializer(), "command", new String[0]);
        op.add(Builder::decisions, JsonpDeserializer.arrayDeserializer(RerouteDecision._DESERIALIZER), "decisions", new String[0]);
        op.add(Builder::parameters, RerouteParameters._DESERIALIZER, "parameters", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RerouteExplanation> {
        private String command;
        private List<RerouteDecision> decisions;
        private RerouteParameters parameters;

        public Builder command(String value) {
            this.command = value;
            return this;
        }

        public Builder decisions(List<RerouteDecision> value) {
            this.decisions = value;
            return this;
        }

        public Builder decisions(RerouteDecision ... value) {
            this.decisions = Arrays.asList(value);
            return this;
        }

        public Builder addDecisions(RerouteDecision value) {
            if (this.decisions == null) {
                this.decisions = new ArrayList<RerouteDecision>();
            }
            this.decisions.add(value);
            return this;
        }

        public Builder decisions(Function<RerouteDecision.Builder, ObjectBuilder<RerouteDecision>> fn) {
            return this.decisions(fn.apply(new RerouteDecision.Builder()).build());
        }

        public Builder addDecisions(Function<RerouteDecision.Builder, ObjectBuilder<RerouteDecision>> fn) {
            return this.addDecisions(fn.apply(new RerouteDecision.Builder()).build());
        }

        public Builder parameters(RerouteParameters value) {
            this.parameters = value;
            return this;
        }

        public Builder parameters(Function<RerouteParameters.Builder, ObjectBuilder<RerouteParameters>> fn) {
            return this.parameters(fn.apply(new RerouteParameters.Builder()).build());
        }

        @Override
        public RerouteExplanation build() {
            return new RerouteExplanation(this);
        }
    }
}

