/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.remote_info;

import co.elastic.clients.elasticsearch.cluster.remote_info.ClusterRemoteInfoVariant;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClusterRemoteProxyInfo
implements ClusterRemoteInfoVariant,
JsonpSerializable {
    private final boolean connected;
    private final String initialConnectTimeout;
    private final boolean skipUnavailable;
    private final String proxyAddress;
    private final String serverName;
    private final int numProxySocketsConnected;
    private final int maxProxySocketConnections;
    public static final JsonpDeserializer<ClusterRemoteProxyInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterRemoteProxyInfo::setupClusterRemoteProxyInfoDeserializer, Builder::build);

    public ClusterRemoteProxyInfo(Builder builder) {
        this.connected = Objects.requireNonNull(builder.connected, "connected");
        this.initialConnectTimeout = Objects.requireNonNull(builder.initialConnectTimeout, "initial_connect_timeout");
        this.skipUnavailable = Objects.requireNonNull(builder.skipUnavailable, "skip_unavailable");
        this.proxyAddress = Objects.requireNonNull(builder.proxyAddress, "proxy_address");
        this.serverName = Objects.requireNonNull(builder.serverName, "server_name");
        this.numProxySocketsConnected = Objects.requireNonNull(builder.numProxySocketsConnected, "num_proxy_sockets_connected");
        this.maxProxySocketConnections = Objects.requireNonNull(builder.maxProxySocketConnections, "max_proxy_socket_connections");
    }

    public ClusterRemoteProxyInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Override
    public String _variantType() {
        return "proxy";
    }

    public boolean connected() {
        return this.connected;
    }

    public String initialConnectTimeout() {
        return this.initialConnectTimeout;
    }

    public boolean skipUnavailable() {
        return this.skipUnavailable;
    }

    public String proxyAddress() {
        return this.proxyAddress;
    }

    public String serverName() {
        return this.serverName;
    }

    public int numProxySocketsConnected() {
        return this.numProxySocketsConnected;
    }

    public int maxProxySocketConnections() {
        return this.maxProxySocketConnections;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("mode", "proxy");
        generator.writeKey("connected");
        generator.write(this.connected);
        generator.writeKey("initial_connect_timeout");
        generator.write(this.initialConnectTimeout);
        generator.writeKey("skip_unavailable");
        generator.write(this.skipUnavailable);
        generator.writeKey("proxy_address");
        generator.write(this.proxyAddress);
        generator.writeKey("server_name");
        generator.write(this.serverName);
        generator.writeKey("num_proxy_sockets_connected");
        generator.write(this.numProxySocketsConnected);
        generator.writeKey("max_proxy_socket_connections");
        generator.write(this.maxProxySocketConnections);
    }

    protected static void setupClusterRemoteProxyInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::connected, JsonpDeserializer.booleanDeserializer(), "connected", new String[0]);
        op.add(Builder::initialConnectTimeout, JsonpDeserializer.stringDeserializer(), "initial_connect_timeout", new String[0]);
        op.add(Builder::skipUnavailable, JsonpDeserializer.booleanDeserializer(), "skip_unavailable", new String[0]);
        op.add(Builder::proxyAddress, JsonpDeserializer.stringDeserializer(), "proxy_address", new String[0]);
        op.add(Builder::serverName, JsonpDeserializer.stringDeserializer(), "server_name", new String[0]);
        op.add(Builder::numProxySocketsConnected, JsonpDeserializer.integerDeserializer(), "num_proxy_sockets_connected", new String[0]);
        op.add(Builder::maxProxySocketConnections, JsonpDeserializer.integerDeserializer(), "max_proxy_socket_connections", new String[0]);
        op.ignore("mode");
    }

    public static class Builder
    implements ObjectBuilder<ClusterRemoteProxyInfo> {
        private Boolean connected;
        private String initialConnectTimeout;
        private Boolean skipUnavailable;
        private String proxyAddress;
        private String serverName;
        private Integer numProxySocketsConnected;
        private Integer maxProxySocketConnections;

        public Builder connected(boolean value) {
            this.connected = value;
            return this;
        }

        public Builder initialConnectTimeout(String value) {
            this.initialConnectTimeout = value;
            return this;
        }

        public Builder skipUnavailable(boolean value) {
            this.skipUnavailable = value;
            return this;
        }

        public Builder proxyAddress(String value) {
            this.proxyAddress = value;
            return this;
        }

        public Builder serverName(String value) {
            this.serverName = value;
            return this;
        }

        public Builder numProxySocketsConnected(int value) {
            this.numProxySocketsConnected = value;
            return this;
        }

        public Builder maxProxySocketConnections(int value) {
            this.maxProxySocketConnections = value;
            return this;
        }

        @Override
        public ClusterRemoteProxyInfo build() {
            return new ClusterRemoteProxyInfo(this);
        }
    }
}

