/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.pending_tasks;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class PendingTask
implements JsonpSerializable {
    private final int insertOrder;
    private final String priority;
    private final String source;
    private final String timeInQueue;
    private final int timeInQueueMillis;
    public static final JsonpDeserializer<PendingTask> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PendingTask::setupPendingTaskDeserializer, Builder::build);

    public PendingTask(Builder builder) {
        this.insertOrder = Objects.requireNonNull(builder.insertOrder, "insert_order");
        this.priority = Objects.requireNonNull(builder.priority, "priority");
        this.source = Objects.requireNonNull(builder.source, "source");
        this.timeInQueue = Objects.requireNonNull(builder.timeInQueue, "time_in_queue");
        this.timeInQueueMillis = Objects.requireNonNull(builder.timeInQueueMillis, "time_in_queue_millis");
    }

    public PendingTask(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public int insertOrder() {
        return this.insertOrder;
    }

    public String priority() {
        return this.priority;
    }

    public String source() {
        return this.source;
    }

    public String timeInQueue() {
        return this.timeInQueue;
    }

    public int timeInQueueMillis() {
        return this.timeInQueueMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("insert_order");
        generator.write(this.insertOrder);
        generator.writeKey("priority");
        generator.write(this.priority);
        generator.writeKey("source");
        generator.write(this.source);
        generator.writeKey("time_in_queue");
        generator.write(this.timeInQueue);
        generator.writeKey("time_in_queue_millis");
        generator.write(this.timeInQueueMillis);
    }

    protected static void setupPendingTaskDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::insertOrder, JsonpDeserializer.integerDeserializer(), "insert_order", new String[0]);
        op.add(Builder::priority, JsonpDeserializer.stringDeserializer(), "priority", new String[0]);
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source", new String[0]);
        op.add(Builder::timeInQueue, JsonpDeserializer.stringDeserializer(), "time_in_queue", new String[0]);
        op.add(Builder::timeInQueueMillis, JsonpDeserializer.integerDeserializer(), "time_in_queue_millis", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PendingTask> {
        private Integer insertOrder;
        private String priority;
        private String source;
        private String timeInQueue;
        private Integer timeInQueueMillis;

        public Builder insertOrder(int value) {
            this.insertOrder = value;
            return this;
        }

        public Builder priority(String value) {
            this.priority = value;
            return this;
        }

        public Builder source(String value) {
            this.source = value;
            return this;
        }

        public Builder timeInQueue(String value) {
            this.timeInQueue = value;
            return this;
        }

        public Builder timeInQueueMillis(int value) {
            this.timeInQueueMillis = value;
            return this;
        }

        @Override
        public PendingTask build() {
            return new PendingTask(this);
        }
    }
}

