/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.UnassignedInformationReason;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class UnassignedInformation
implements JsonpSerializable {
    private final String at;
    @Nullable
    private final String lastAllocationStatus;
    private final UnassignedInformationReason reason;
    @Nullable
    private final String details;
    @Nullable
    private final Integer failedAllocationAttempts;
    @Nullable
    private final Boolean delayed;
    @Nullable
    private final String allocationStatus;
    public static final JsonpDeserializer<UnassignedInformation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UnassignedInformation::setupUnassignedInformationDeserializer, Builder::build);

    public UnassignedInformation(Builder builder) {
        this.at = Objects.requireNonNull(builder.at, "at");
        this.lastAllocationStatus = builder.lastAllocationStatus;
        this.reason = Objects.requireNonNull(builder.reason, "reason");
        this.details = builder.details;
        this.failedAllocationAttempts = builder.failedAllocationAttempts;
        this.delayed = builder.delayed;
        this.allocationStatus = builder.allocationStatus;
    }

    public UnassignedInformation(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String at() {
        return this.at;
    }

    @Nullable
    public String lastAllocationStatus() {
        return this.lastAllocationStatus;
    }

    public UnassignedInformationReason reason() {
        return this.reason;
    }

    @Nullable
    public String details() {
        return this.details;
    }

    @Nullable
    public Integer failedAllocationAttempts() {
        return this.failedAllocationAttempts;
    }

    @Nullable
    public Boolean delayed() {
        return this.delayed;
    }

    @Nullable
    public String allocationStatus() {
        return this.allocationStatus;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("at");
        generator.write(this.at);
        if (this.lastAllocationStatus != null) {
            generator.writeKey("last_allocation_status");
            generator.write(this.lastAllocationStatus);
        }
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
        if (this.details != null) {
            generator.writeKey("details");
            generator.write(this.details);
        }
        if (this.failedAllocationAttempts != null) {
            generator.writeKey("failed_allocation_attempts");
            generator.write(this.failedAllocationAttempts.intValue());
        }
        if (this.delayed != null) {
            generator.writeKey("delayed");
            generator.write(this.delayed.booleanValue());
        }
        if (this.allocationStatus != null) {
            generator.writeKey("allocation_status");
            generator.write(this.allocationStatus);
        }
    }

    protected static void setupUnassignedInformationDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::at, JsonpDeserializer.stringDeserializer(), "at", new String[0]);
        op.add(Builder::lastAllocationStatus, JsonpDeserializer.stringDeserializer(), "last_allocation_status", new String[0]);
        op.add(Builder::reason, UnassignedInformationReason._DESERIALIZER, "reason", new String[0]);
        op.add(Builder::details, JsonpDeserializer.stringDeserializer(), "details", new String[0]);
        op.add(Builder::failedAllocationAttempts, JsonpDeserializer.integerDeserializer(), "failed_allocation_attempts", new String[0]);
        op.add(Builder::delayed, JsonpDeserializer.booleanDeserializer(), "delayed", new String[0]);
        op.add(Builder::allocationStatus, JsonpDeserializer.stringDeserializer(), "allocation_status", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<UnassignedInformation> {
        private String at;
        @Nullable
        private String lastAllocationStatus;
        private UnassignedInformationReason reason;
        @Nullable
        private String details;
        @Nullable
        private Integer failedAllocationAttempts;
        @Nullable
        private Boolean delayed;
        @Nullable
        private String allocationStatus;

        public Builder at(String value) {
            this.at = value;
            return this;
        }

        public Builder lastAllocationStatus(@Nullable String value) {
            this.lastAllocationStatus = value;
            return this;
        }

        public Builder reason(UnassignedInformationReason value) {
            this.reason = value;
            return this;
        }

        public Builder details(@Nullable String value) {
            this.details = value;
            return this;
        }

        public Builder failedAllocationAttempts(@Nullable Integer value) {
            this.failedAllocationAttempts = value;
            return this;
        }

        public Builder delayed(@Nullable Boolean value) {
            this.delayed = value;
            return this;
        }

        public Builder allocationStatus(@Nullable String value) {
            this.allocationStatus = value;
            return this;
        }

        @Override
        public UnassignedInformation build() {
            return new UnassignedInformation(this);
        }
    }
}

