/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.allocation_explain;

import co.elastic.clients.elasticsearch.cluster.allocation_explain.DiskUsage;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class NodeDiskUsage
implements JsonpSerializable {
    private final String nodeName;
    private final DiskUsage leastAvailable;
    private final DiskUsage mostAvailable;
    public static final JsonpDeserializer<NodeDiskUsage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeDiskUsage::setupNodeDiskUsageDeserializer, Builder::build);

    public NodeDiskUsage(Builder builder) {
        this.nodeName = Objects.requireNonNull(builder.nodeName, "node_name");
        this.leastAvailable = Objects.requireNonNull(builder.leastAvailable, "least_available");
        this.mostAvailable = Objects.requireNonNull(builder.mostAvailable, "most_available");
    }

    public NodeDiskUsage(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String nodeName() {
        return this.nodeName;
    }

    public DiskUsage leastAvailable() {
        return this.leastAvailable;
    }

    public DiskUsage mostAvailable() {
        return this.mostAvailable;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_name");
        generator.write(this.nodeName);
        generator.writeKey("least_available");
        this.leastAvailable.serialize(generator, mapper);
        generator.writeKey("most_available");
        this.mostAvailable.serialize(generator, mapper);
    }

    protected static void setupNodeDiskUsageDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodeName, JsonpDeserializer.stringDeserializer(), "node_name", new String[0]);
        op.add(Builder::leastAvailable, DiskUsage._DESERIALIZER, "least_available", new String[0]);
        op.add(Builder::mostAvailable, DiskUsage._DESERIALIZER, "most_available", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeDiskUsage> {
        private String nodeName;
        private DiskUsage leastAvailable;
        private DiskUsage mostAvailable;

        public Builder nodeName(String value) {
            this.nodeName = value;
            return this;
        }

        public Builder leastAvailable(DiskUsage value) {
            this.leastAvailable = value;
            return this;
        }

        public Builder leastAvailable(Function<DiskUsage.Builder, ObjectBuilder<DiskUsage>> fn) {
            return this.leastAvailable(fn.apply(new DiskUsage.Builder()).build());
        }

        public Builder mostAvailable(DiskUsage value) {
            this.mostAvailable = value;
            return this;
        }

        public Builder mostAvailable(Function<DiskUsage.Builder, ObjectBuilder<DiskUsage>> fn) {
            return this.mostAvailable(fn.apply(new DiskUsage.Builder()).build());
        }

        @Override
        public NodeDiskUsage build() {
            return new NodeDiskUsage(this);
        }
    }
}

